/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.core;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.servicecomb.saga.alpha.core.TaskStatus;
import org.apache.servicecomb.saga.alpha.core.TxEvent;

@Entity
@Table(name="Command")
public class Command {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long surrogateId;
    private long eventId;
    private String serviceName;
    private String instanceId;
    private String globalTxId;
    private String localTxId;
    private String parentTxId;
    private String compensationMethod;
    private byte[] payloads;
    private String status;
    private Date lastModified;
    @Version
    private long version;

    Command() {
    }

    private Command(long id, String serviceName, String instanceId, String globalTxId, String localTxId, String parentTxId, String compensationMethod, byte[] payloads, String status) {
        this.eventId = id;
        this.serviceName = serviceName;
        this.instanceId = instanceId;
        this.globalTxId = globalTxId;
        this.localTxId = localTxId;
        this.parentTxId = parentTxId;
        this.compensationMethod = compensationMethod;
        this.payloads = payloads;
        this.status = status;
        this.lastModified = new Date();
    }

    public Command(long id, String serviceName, String instanceId, String globalTxId, String localTxId, String parentTxId, String compensationMethod, byte[] payloads) {
        this(id, serviceName, instanceId, globalTxId, localTxId, parentTxId, compensationMethod, payloads, TaskStatus.NEW.name());
    }

    public Command(TxEvent event) {
        this(event.id(), event.serviceName(), event.instanceId(), event.globalTxId(), event.localTxId(), event.parentTxId(), event.compensationMethod(), event.payloads());
    }

    String serviceName() {
        return this.serviceName;
    }

    String instanceId() {
        return this.instanceId;
    }

    public String globalTxId() {
        return this.globalTxId;
    }

    public String localTxId() {
        return this.localTxId;
    }

    public String parentTxId() {
        return this.parentTxId;
    }

    public String compensationMethod() {
        return this.compensationMethod;
    }

    byte[] payloads() {
        return this.payloads;
    }

    String status() {
        return this.status;
    }

    long id() {
        return this.surrogateId;
    }

    public String toString() {
        return "Command{eventId=" + this.eventId + ", serviceName='" + this.serviceName + '\'' + ", instanceId='" + this.instanceId + '\'' + ", globalTxId='" + this.globalTxId + '\'' + ", localTxId='" + this.localTxId + '\'' + ", parentTxId='" + this.parentTxId + '\'' + ", compensationMethod='" + this.compensationMethod + '\'' + '}';
    }
}

