/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import java.util.List;
import javax.persistence.LockModeType;
import javax.transaction.Transactional;
import org.apache.servicecomb.saga.alpha.core.TxTimeout;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;

interface TxTimeoutEntityRepository
extends CrudRepository<TxTimeout, Long> {
    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="UPDATE org.apache.servicecomb.saga.alpha.core.TxTimeout t SET t.status = :status WHERE t.globalTxId = :globalTxId   AND t.localTxId = :localTxId")
    public void updateStatusByGlobalTxIdAndLocalTxId(@Param(value="status") String var1, @Param(value="globalTxId") String var2, @Param(value="localTxId") String var3);

    @Lock(value=LockModeType.OPTIMISTIC)
    @Query(value="SELECT t FROM TxTimeout AS t WHERE t.status = 'NEW'   AND t.expiryTime < CURRENT_TIMESTAMP ORDER BY t.expiryTime ASC")
    public List<TxTimeout> findFirstTimeoutTxOrderByExpireTimeAsc(Pageable var1);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="UPDATE TxTimeout t SET t.status = 'DONE' WHERE t.status != 'DONE' AND EXISTS (  SELECT t1.globalTxId FROM TxEvent t1   WHERE t1.globalTxId = t.globalTxId     AND t1.localTxId = t.localTxId     AND t1.type != t.type)")
    public void updateStatusOfFinishedTx();
}

