/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.saga.alpha.core.OmegaCallback;
import org.apache.servicecomb.saga.alpha.core.TxConsistentService;
import org.apache.servicecomb.saga.alpha.core.TxEvent;
import org.apache.servicecomb.saga.alpha.server.GrpcOmegaCallback;
import org.apache.servicecomb.saga.pack.contract.grpc.GrpcAck;
import org.apache.servicecomb.saga.pack.contract.grpc.GrpcCompensateCommand;
import org.apache.servicecomb.saga.pack.contract.grpc.GrpcServiceConfig;
import org.apache.servicecomb.saga.pack.contract.grpc.GrpcTxEvent;
import org.apache.servicecomb.saga.pack.contract.grpc.TxEventServiceGrpc;

class GrpcTxEventEndpointImpl
extends TxEventServiceGrpc.TxEventServiceImplBase {
    private static final GrpcAck ALLOW = GrpcAck.newBuilder().setAborted(false).build();
    private static final GrpcAck REJECT = GrpcAck.newBuilder().setAborted(true).build();
    private final TxConsistentService txConsistentService;
    private final Map<String, Map<String, OmegaCallback>> omegaCallbacks;

    GrpcTxEventEndpointImpl(TxConsistentService txConsistentService, Map<String, Map<String, OmegaCallback>> omegaCallbacks) {
        this.txConsistentService = txConsistentService;
        this.omegaCallbacks = omegaCallbacks;
    }

    public void onConnected(GrpcServiceConfig request, StreamObserver<GrpcCompensateCommand> responseObserver) {
        this.omegaCallbacks.computeIfAbsent(request.getServiceName(), key -> new ConcurrentHashMap()).put(request.getInstanceId(), new GrpcOmegaCallback(responseObserver));
    }

    public void onDisconnected(GrpcServiceConfig request, StreamObserver<GrpcAck> responseObserver) {
        OmegaCallback callback = (OmegaCallback)this.omegaCallbacks.getOrDefault(request.getServiceName(), Collections.emptyMap()).remove(request.getInstanceId());
        if (callback != null) {
            callback.disconnect();
        }
        responseObserver.onNext((Object)ALLOW);
        responseObserver.onCompleted();
    }

    public void onTxEvent(GrpcTxEvent message, StreamObserver<GrpcAck> responseObserver) {
        boolean ok = this.txConsistentService.handle(new TxEvent(message.getServiceName(), message.getInstanceId(), new Date(), message.getGlobalTxId(), message.getLocalTxId(), message.getParentTxId().isEmpty() ? null : message.getParentTxId(), message.getType(), message.getCompensationMethod(), message.getTimeout(), message.getRetryMethod(), message.getRetries(), message.getPayloads().toByteArray()));
        responseObserver.onNext((Object)(ok ? ALLOW : REJECT));
        responseObserver.onCompleted();
    }
}

