/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import io.grpc.BindableService;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.servicecomb.saga.alpha.core.CommandRepository;
import org.apache.servicecomb.saga.alpha.core.CompositeOmegaCallback;
import org.apache.servicecomb.saga.alpha.core.EventScanner;
import org.apache.servicecomb.saga.alpha.core.OmegaCallback;
import org.apache.servicecomb.saga.alpha.core.PendingTaskRunner;
import org.apache.servicecomb.saga.alpha.core.PushBackOmegaCallback;
import org.apache.servicecomb.saga.alpha.core.TxConsistentService;
import org.apache.servicecomb.saga.alpha.core.TxEventRepository;
import org.apache.servicecomb.saga.alpha.core.TxTimeoutRepository;
import org.apache.servicecomb.saga.alpha.server.CommandEntityRepository;
import org.apache.servicecomb.saga.alpha.server.GrpcServerConfig;
import org.apache.servicecomb.saga.alpha.server.GrpcStartable;
import org.apache.servicecomb.saga.alpha.server.GrpcTxEventEndpointImpl;
import org.apache.servicecomb.saga.alpha.server.ServerStartable;
import org.apache.servicecomb.saga.alpha.server.SpringCommandRepository;
import org.apache.servicecomb.saga.alpha.server.SpringTxEventRepository;
import org.apache.servicecomb.saga.alpha.server.SpringTxTimeoutRepository;
import org.apache.servicecomb.saga.alpha.server.TxEventEnvelopeRepository;
import org.apache.servicecomb.saga.alpha.server.TxTimeoutEntityRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EntityScan(basePackages={"org.apache.servicecomb.saga.alpha"})
@Configuration
class AlphaConfig {
    private final BlockingQueue<Runnable> pendingCompensations = new LinkedBlockingQueue();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    @Value(value="${alpha.compensation.retry.delay:3000}")
    private int delay;

    AlphaConfig() {
    }

    @Bean
    Map<String, Map<String, OmegaCallback>> omegaCallbacks() {
        return new ConcurrentHashMap<String, Map<String, OmegaCallback>>();
    }

    @Bean
    OmegaCallback omegaCallback(Map<String, Map<String, OmegaCallback>> callbacks) {
        return new PushBackOmegaCallback(this.pendingCompensations, (OmegaCallback)new CompositeOmegaCallback(callbacks));
    }

    @Bean
    TxEventRepository springTxEventRepository(TxEventEnvelopeRepository eventRepo) {
        return new SpringTxEventRepository(eventRepo);
    }

    @Bean
    CommandRepository springCommandRepository(TxEventEnvelopeRepository eventRepo, CommandEntityRepository commandRepository) {
        return new SpringCommandRepository(eventRepo, commandRepository);
    }

    @Bean
    TxTimeoutRepository springTxTimeoutRepository(TxTimeoutEntityRepository timeoutRepo) {
        return new SpringTxTimeoutRepository(timeoutRepo);
    }

    @Bean
    ScheduledExecutorService compensationScheduler() {
        return this.scheduler;
    }

    @Bean
    GrpcServerConfig grpcServerConfig() {
        return new GrpcServerConfig();
    }

    @Bean
    TxConsistentService txConsistentService(@Value(value="${alpha.event.pollingInterval:500}") int eventPollingInterval, GrpcServerConfig serverConfig, ScheduledExecutorService scheduler, TxEventRepository eventRepository, CommandRepository commandRepository, TxTimeoutRepository timeoutRepository, OmegaCallback omegaCallback, Map<String, Map<String, OmegaCallback>> omegaCallbacks) {
        new EventScanner(scheduler, eventRepository, commandRepository, timeoutRepository, omegaCallback, eventPollingInterval).run();
        TxConsistentService consistentService = new TxConsistentService(eventRepository);
        ServerStartable startable = this.buildGrpc(serverConfig, consistentService, omegaCallbacks);
        new Thread(() -> ((ServerStartable)startable).start()).start();
        return consistentService;
    }

    private ServerStartable buildGrpc(GrpcServerConfig serverConfig, TxConsistentService txConsistentService, Map<String, Map<String, OmegaCallback>> omegaCallbacks) {
        return new GrpcStartable(serverConfig, new BindableService[]{new GrpcTxEventEndpointImpl(txConsistentService, omegaCallbacks)});
    }

    @PostConstruct
    void init() {
        new PendingTaskRunner(this.pendingCompensations, this.delay).run();
    }

    @PreDestroy
    void shutdown() {
        this.scheduler.shutdownNow();
    }
}

