/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.transports.httpclient;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.core.util.IOUtils;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SuccessfulSagaResponse;
import org.apache.servicecomb.saga.core.TransportFailedException;
import org.apache.servicecomb.saga.transports.RestTransport;

@EnableKamon
public class HttpClientTransport
implements RestTransport {
    private final int requestTimeout;
    private static final int DEFAULT_REQUEST_TIMEOUT = 30000;
    private static final Map<String, Function<URI, Request>> requestFactories = new HashMap<String, Function<URI, Request>>(){
        {
            this.put("GET", Request::Get);
            this.put("POST", Request::Post);
            this.put("PUT", Request::Put);
            this.put("DELETE", Request::Delete);
        }
    };

    public HttpClientTransport() {
        this(30000);
    }

    public HttpClientTransport(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Segment(name="transport", category="network", library="kamon")
    public SagaResponse with(String address, String path, String method, Map<String, Map<String, String>> params) {
        URIBuilder builder = new URIBuilder().setScheme("http").setHost(address).setPath(path);
        if (params.containsKey("query")) {
            for (Map.Entry<String, String> entry : params.get("query").entrySet()) {
                builder.addParameter(entry.getKey(), entry.getValue());
            }
        }
        try {
            URI uri = builder.build();
            Request request = requestFactories.getOrDefault(method.toUpperCase(), this.exceptionThrowingFunction(method)).apply(uri);
            request.socketTimeout(this.requestTimeout);
            if (params.containsKey("json")) {
                request.bodyString(params.get("json").get("body"), ContentType.APPLICATION_JSON);
            }
            if (params.containsKey("form")) {
                Form form = Form.form();
                for (Map.Entry<String, String> entry : params.get("form").entrySet()) {
                    form.add(entry.getKey(), entry.getValue()).build();
                }
                request.bodyForm((Iterable)form.build());
            }
            return this.on(request);
        }
        catch (URISyntaxException e) {
            throw new TransportFailedException("Wrong request URI", (Throwable)e);
        }
    }

    private Function<URI, Request> exceptionThrowingFunction(String method) {
        return u -> {
            throw new TransportFailedException("No such method " + method);
        };
    }

    private SagaResponse on(Request request) {
        try {
            HttpResponse httpResponse = request.execute().returnResponse();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String content = IOUtils.toString((Reader)new InputStreamReader(httpResponse.getEntity().getContent()));
            if (statusCode >= 200 && statusCode < 300) {
                return new SuccessfulSagaResponse(content);
            }
            throw new TransportFailedException("The remote service returned with status code " + statusCode + ", reason " + httpResponse.getStatusLine().getReasonPhrase() + ", and content " + content);
        }
        catch (IOException e) {
            throw new TransportFailedException("Network Error", (Throwable)e);
        }
    }
}

