/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.servicecomb.saga.core.Compensation;
import org.apache.servicecomb.saga.core.Fallback;
import org.apache.servicecomb.saga.core.Operation;
import org.apache.servicecomb.saga.core.SagaRequestImpl;
import org.apache.servicecomb.saga.core.Transaction;
import org.apache.servicecomb.saga.format.JacksonFallback;
import org.apache.servicecomb.saga.format.JacksonRestCompensation;
import org.apache.servicecomb.saga.format.JacksonRestTransaction;
import org.apache.servicecomb.saga.format.JsonSagaRequest;
import org.apache.servicecomb.saga.transports.RestTransport;
import org.apache.servicecomb.saga.transports.TransportFactory;

public class JsonRestSagaRequest
extends SagaRequestImpl
implements JsonSagaRequest<RestTransport> {
    private final JacksonRestTransaction transaction;
    private final JacksonRestCompensation compensation;
    private final JacksonFallback fallback;

    @JsonCreator
    public JsonRestSagaRequest(@JsonProperty(value="id") String id, @JsonProperty(value="serviceName") String serviceName, @JsonProperty(value="type") String type, @JsonProperty(value="transaction") JacksonRestTransaction transaction, @JsonProperty(value="compensation") JacksonRestCompensation compensation, @JsonProperty(value="fallback") JacksonFallback fallback, @JsonProperty(value="parents") String[] parents, @JsonProperty(value="failRetryDelayMilliseconds") int failRetryDelayMilliseconds) {
        super(id, serviceName, type, (Transaction)transaction, (Compensation)compensation, (Fallback)(fallback == null ? JacksonFallback.NOP_TRANSPORT_AWARE_FALLBACK : fallback), parents, failRetryDelayMilliseconds);
        this.checkNull((Operation)transaction, "transaction");
        this.checkNull((Operation)compensation, "compensation");
        this.transaction = transaction;
        this.compensation = compensation;
        this.fallback = fallback == null ? JacksonFallback.NOP_TRANSPORT_AWARE_FALLBACK : fallback;
    }

    @Override
    public JsonSagaRequest with(TransportFactory transportFactory) {
        this.transaction.with(transportFactory);
        this.compensation.with(transportFactory);
        this.fallback.with(transportFactory);
        return this;
    }

    private void checkNull(Operation operation, String operationName) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid request with NO " + operationName + " specified");
        }
    }
}

