/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.format;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.saga.core.FailedSagaRequestContext;
import org.apache.servicecomb.saga.core.NoOpSagaRequest;
import org.apache.servicecomb.saga.core.SagaEndedEvent;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.apache.servicecomb.saga.core.SagaException;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaStartedEvent;
import org.apache.servicecomb.saga.core.SuccessfulSagaRequestContext;
import org.apache.servicecomb.saga.core.TransactionAbortedEvent;
import org.apache.servicecomb.saga.core.TransactionCompensatedEvent;
import org.apache.servicecomb.saga.core.TransactionEndedEvent;
import org.apache.servicecomb.saga.core.TransactionStartedEvent;
import org.apache.servicecomb.saga.format.JsonSagaRequest;
import org.apache.servicecomb.saga.format.SagaEventFormat;
import org.apache.servicecomb.saga.transports.TransportFactory;

public class JacksonSagaEventFormat
implements SagaEventFormat {
    private final Map<String, BiFunction<String, String, SagaEvent>> eventFactories = new HashMap<String, BiFunction<String, String, SagaEvent>>(){
        {
            this.put(SagaStartedEvent.class.getSimpleName(), new BiFunction<String, String, SagaEvent>(){

                @Override
                public SagaEvent apply(String sagaId, String json) {
                    return JacksonSagaEventFormat.this.sagaStartedEvent(sagaId, json);
                }
            });
            this.put(TransactionStartedEvent.class.getSimpleName(), new BiFunction<String, String, SagaEvent>(){

                @Override
                public SagaEvent apply(String sagaId, String json) {
                    return JacksonSagaEventFormat.this.transactionStartedEvent(sagaId, json);
                }
            });
            this.put(TransactionEndedEvent.class.getSimpleName(), new BiFunction<String, String, SagaEvent>(){

                @Override
                public SagaEvent apply(String sagaId, String json) {
                    return JacksonSagaEventFormat.this.transactionEndedEvent(sagaId, json);
                }
            });
            this.put(TransactionAbortedEvent.class.getSimpleName(), new BiFunction<String, String, SagaEvent>(){

                @Override
                public SagaEvent apply(String sagaId, String json) {
                    return JacksonSagaEventFormat.this.transactionAbortedEvent(sagaId, json);
                }
            });
            this.put(TransactionCompensatedEvent.class.getSimpleName(), new BiFunction<String, String, SagaEvent>(){

                @Override
                public SagaEvent apply(String sagaId, String json) {
                    return JacksonSagaEventFormat.this.compensationEndedEvent(sagaId, json);
                }
            });
            this.put(SagaEndedEvent.class.getSimpleName(), new BiFunction<String, String, SagaEvent>(){

                @Override
                public SagaEvent apply(String sagaId, String json) {
                    return JacksonSagaEventFormat.this.sagaEndedEvent(sagaId);
                }
            });
        }
    };
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TransportFactory transportFactory;

    public JacksonSagaEventFormat(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    @Override
    public SagaEvent toSagaEvent(String sagaId, String eventType, String contentJson) {
        return this.eventFactories.get(eventType).apply(sagaId, contentJson);
    }

    private SagaEvent sagaStartedEvent(String sagaId, String json) {
        return new SagaStartedEvent(sagaId, json, NoOpSagaRequest.SAGA_START_REQUEST);
    }

    private SagaEvent transactionStartedEvent(String sagaId, String json) {
        try {
            return new TransactionStartedEvent(sagaId, (SagaRequest)((JsonSagaRequest)this.objectMapper.readValue(json, JsonSagaRequest.class)).with(this.transportFactory));
        }
        catch (IOException e) {
            throw new SagaException(this.cause(sagaId, json), (Throwable)e);
        }
    }

    private SagaEvent transactionEndedEvent(String sagaId, String json) {
        try {
            SuccessfulSagaRequestContext context = (SuccessfulSagaRequestContext)this.objectMapper.readValue(json, SuccessfulSagaRequestContext.class);
            return new TransactionEndedEvent(sagaId, (SagaRequest)context.request().with(this.transportFactory), context.response());
        }
        catch (IOException e) {
            throw new SagaException(this.cause(sagaId, json), (Throwable)e);
        }
    }

    private SagaEvent transactionAbortedEvent(String sagaId, String json) {
        try {
            FailedSagaRequestContext context = (FailedSagaRequestContext)this.objectMapper.readValue(json, FailedSagaRequestContext.class);
            return new TransactionAbortedEvent(sagaId, (SagaRequest)context.request().with(this.transportFactory), context.response());
        }
        catch (IOException e) {
            throw new SagaException(this.cause(sagaId, json), (Throwable)e);
        }
    }

    private SagaEvent compensationEndedEvent(String sagaId, String json) {
        try {
            SuccessfulSagaRequestContext context = (SuccessfulSagaRequestContext)this.objectMapper.readValue(json, SuccessfulSagaRequestContext.class);
            return new TransactionCompensatedEvent(sagaId, (SagaRequest)context.request().with(this.transportFactory), context.response());
        }
        catch (IOException e) {
            throw new SagaException(this.cause(sagaId, json), (Throwable)e);
        }
    }

    private SagaEvent sagaEndedEvent(String sagaId) {
        return new SagaEndedEvent(sagaId, NoOpSagaRequest.SAGA_END_REQUEST);
    }

    private String cause(String sagaId, String json) {
        return "Failed to deserialize saga event of sage id: " + sagaId + " from json: " + json;
    }

    private static interface BiFunction<T, U, R> {
        public R apply(T var1, U var2);
    }
}

