/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.SagaException;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaRequestContext;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.ToJsonFormat;

@EnableKamon
public class JacksonToJsonFormat
implements ToJsonFormat {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JacksonToJsonFormat() {
        this.objectMapper.setVisibility(this.objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }

    @Segment(name="toJson", category="application", library="kamon")
    public String toJson(SagaRequest request) {
        try {
            return this.objectMapper.writeValueAsString((Object)request);
        }
        catch (JsonProcessingException e) {
            throw new SagaException("Failed to serialize request to JSON: " + request, (Throwable)e);
        }
    }

    @Segment(name="toJson", category="application", library="kamon")
    public String toJson(SagaRequest request, SagaResponse response) {
        try {
            return this.objectMapper.writeValueAsString((Object)new SagaRequestContext(request, response));
        }
        catch (JsonProcessingException e) {
            throw new SagaException("Failed to serialize request & response to JSON: " + request + ", " + response, (Throwable)e);
        }
    }
}

