/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.infrastructure;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.servicecomb.saga.core.EventEnvelope;
import org.apache.servicecomb.saga.core.EventStore;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedEventStore
implements EventStore {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Queue<SagaEvent> events = new LinkedBlockingQueue<SagaEvent>();

    @Override
    public void offer(SagaEvent sagaEvent) {
        this.events.offer(sagaEvent);
        log.info("Added event {}", (Object)sagaEvent);
    }

    @Override
    public void populate(Iterable<EventEnvelope> events) {
        for (EventEnvelope event : events) {
            this.events.offer(event.event);
            log.info("Populated event {}", (Object)event);
        }
    }

    @Override
    public long size() {
        return this.events.size();
    }

    @Override
    public Iterator<SagaEvent> iterator() {
        return this.events.iterator();
    }
}

