/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.infrastructure;

import java.util.Iterator;
import org.apache.servicecomb.saga.core.EventEnvelope;
import org.apache.servicecomb.saga.core.EventStore;
import org.apache.servicecomb.saga.core.SagaContext;
import org.apache.servicecomb.saga.core.SagaEvent;

public class ContextAwareEventStore
implements EventStore {
    private final EventStore eventStore;
    private final SagaContext sagaContext;

    public ContextAwareEventStore(EventStore eventStore, SagaContext sagaContext) {
        this.eventStore = eventStore;
        this.sagaContext = sagaContext;
    }

    @Override
    public void offer(SagaEvent sagaEvent) {
        sagaEvent.gatherTo(this.sagaContext);
        this.eventStore.offer(sagaEvent);
    }

    @Override
    public void populate(Iterable<EventEnvelope> events) {
        this.eventStore.populate(events);
    }

    @Override
    public long size() {
        return this.eventStore.size();
    }

    @Override
    public Iterator<SagaEvent> iterator() {
        return this.eventStore.iterator();
    }
}

