/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.dag;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Node<T> {
    private final long id;
    private final T value;
    private final Set<Node<T>> children = new HashSet<Node<T>>();
    private final Set<Node<T>> parents = new HashSet<Node<T>>();

    public Node(long id, T value) {
        this.id = id;
        this.value = value;
    }

    long id() {
        return this.id;
    }

    public T value() {
        return this.value;
    }

    Set<Node<T>> parents() {
        return this.parents;
    }

    public Set<Node<T>> children() {
        return this.children;
    }

    public void addChild(Node<T> node) {
        this.children.add(node);
        node.parents.add(this);
    }

    public void addChildren(Collection<Node<T>> nodes) {
        this.children.addAll(nodes);
        for (Node<T> node : nodes) {
            node.parents.add(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.id == node.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Node{id=" + this.id + ", value=" + this.value + '}';
    }
}

