/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.dag;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.servicecomb.saga.core.dag.GraphCycleDetector;
import org.apache.servicecomb.saga.core.dag.Node;
import org.apache.servicecomb.saga.core.dag.SingleLeafDirectedAcyclicGraph;

public class GraphCycleDetectorImpl<T>
implements GraphCycleDetector<T> {
    @Override
    public Set<Node<T>> cycleJoints(SingleLeafDirectedAcyclicGraph<T> graph) {
        LinkedList<Node<T>> orphanNodes = new LinkedList<Node<T>>();
        HashMap<Node<T>, Set<Node<T>>> nodeParents = new HashMap<Node<T>, Set<Node<T>>>();
        orphanNodes.add(graph.root());
        this.traverse(orphanNodes, nodeParents);
        return this.unvisitedNodes(nodeParents);
    }

    private void traverse(Queue<Node<T>> orphanNodes, Map<Node<T>, Set<Node<T>>> nodeParents) {
        while (!orphanNodes.isEmpty()) {
            Node<T> node = orphanNodes.poll();
            for (Node<T> child : node.children()) {
                Set<Node<T>> parent = nodeParents.get(child);
                if (parent == null) {
                    parent = new HashSet<Node<T>>(child.parents());
                    nodeParents.put(child, parent);
                }
                parent.remove(node);
                if (!nodeParents.get(child).isEmpty()) continue;
                orphanNodes.add(child);
            }
        }
    }

    private Set<Node<T>> unvisitedNodes(Map<Node<T>, Set<Node<T>>> nodeParents) {
        HashSet<Node<T>> result = new HashSet<Node<T>>();
        for (Map.Entry<Node<T>, Set<Node<T>>> entry : nodeParents.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.add(entry.getKey());
        }
        return result;
    }
}

