/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.dag;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.NoOpSagaRequest;
import org.apache.servicecomb.saga.core.SagaException;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.dag.GraphCycleDetector;
import org.apache.servicecomb.saga.core.dag.Node;
import org.apache.servicecomb.saga.core.dag.SingleLeafDirectedAcyclicGraph;

@EnableKamon
public class GraphBuilder {
    private final GraphCycleDetector<SagaRequest> detector;

    public GraphBuilder(GraphCycleDetector<SagaRequest> detector) {
        this.detector = detector;
    }

    @Segment(name="buildGraph", category="application", library="kamon")
    public SingleLeafDirectedAcyclicGraph<SagaRequest> build(SagaRequest[] sagaRequests) {
        Map<String, Node<SagaRequest>> requestNodes = this.requestsToNodes(sagaRequests);
        SingleLeafDirectedAcyclicGraph<SagaRequest> graph = this.linkNodesToGraph(sagaRequests, requestNodes);
        this.detectCycle(graph);
        return graph;
    }

    private SingleLeafDirectedAcyclicGraph<SagaRequest> linkNodesToGraph(SagaRequest[] sagaRequests, Map<String, Node<SagaRequest>> requestNodes) {
        Node<SagaRequest> root = this.rootNode(0);
        Node<SagaRequest> leaf = this.leafNode(sagaRequests.length + 1);
        for (SagaRequest sagaRequest : sagaRequests) {
            if (this.isOrphan(sagaRequest)) {
                root.addChild(requestNodes.get(sagaRequest.id()));
                continue;
            }
            for (String parent : sagaRequest.parents()) {
                requestNodes.get(parent).addChild(requestNodes.get(sagaRequest.id()));
            }
        }
        for (Node node : requestNodes.values()) {
            if (!node.children().isEmpty()) continue;
            node.addChild(leaf);
        }
        return new SingleLeafDirectedAcyclicGraph<SagaRequest>(root, leaf);
    }

    private Node<SagaRequest> rootNode(int id) {
        return new Node<SagaRequest>(id, NoOpSagaRequest.SAGA_START_REQUEST);
    }

    private Node<SagaRequest> leafNode(int id) {
        return new Node<SagaRequest>(id, NoOpSagaRequest.SAGA_END_REQUEST);
    }

    private boolean isOrphan(SagaRequest sagaRequest) {
        return sagaRequest.parents().length == 0;
    }

    private Map<String, Node<SagaRequest>> requestsToNodes(SagaRequest[] sagaRequests) {
        long index = 1L;
        HashMap<String, Node<SagaRequest>> requestMap = new HashMap<String, Node<SagaRequest>>();
        for (SagaRequest sagaRequest : sagaRequests) {
            if (requestMap.containsKey(sagaRequest.id())) {
                throw new SagaException("Failed to interpret requests with duplicate request id: " + sagaRequest.id());
            }
            requestMap.put(sagaRequest.id(), new Node<SagaRequest>(index++, sagaRequest));
        }
        return requestMap;
    }

    private void detectCycle(SingleLeafDirectedAcyclicGraph<SagaRequest> graph) {
        Set<Node<SagaRequest>> jointNodes = this.detector.cycleJoints(graph);
        if (!jointNodes.isEmpty()) {
            throw new SagaException("Cycle detected in the request graph at nodes " + jointNodes);
        }
    }
}

