/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.dag;

import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicecomb.saga.core.EventStore;
import org.apache.servicecomb.saga.core.GraphBasedSaga;
import org.apache.servicecomb.saga.core.PersistentStore;
import org.apache.servicecomb.saga.core.Saga;
import org.apache.servicecomb.saga.core.SagaContextImpl;
import org.apache.servicecomb.saga.core.SagaDefinition;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaTaskFactory;
import org.apache.servicecomb.saga.core.application.SagaFactory;
import org.apache.servicecomb.saga.core.application.interpreter.FromJsonFormat;
import org.apache.servicecomb.saga.core.dag.GraphBuilder;
import org.apache.servicecomb.saga.core.dag.GraphCycleDetectorImpl;
import org.apache.servicecomb.saga.infrastructure.ContextAwareEventStore;

public class GraphBasedSagaFactory
implements SagaFactory {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final FromJsonFormat<Set<String>> childrenExtractor;
    private final Executor executorService;
    private final GraphBuilder graphBuilder;
    private final SagaTaskFactory sagaTaskFactory;

    public GraphBasedSagaFactory(int retryDelay, PersistentStore persistentStore, FromJsonFormat<Set<String>> childrenExtractor, ExecutorService executorService) {
        this.childrenExtractor = childrenExtractor;
        this.executorService = executorService;
        this.sagaTaskFactory = new SagaTaskFactory(retryDelay, persistentStore);
        this.graphBuilder = new GraphBuilder(new GraphCycleDetectorImpl<SagaRequest>());
    }

    @Override
    public Saga createSaga(String requestJson, String sagaId, EventStore sagaLog, SagaDefinition definition) {
        SagaContextImpl sagaContext = new SagaContextImpl(this.childrenExtractor);
        return new GraphBasedSaga(sagaLog, this.executorService, this.sagaTaskFactory.sagaTasks(sagaId, requestJson, definition.policy(), new ContextAwareEventStore(sagaLog, sagaContext)), sagaContext, this.graphBuilder.build(definition.requests()));
    }

    @Override
    public boolean isTerminated() {
        return !this.isRunning.get();
    }

    @Override
    public void terminate() throws Exception {
        this.isRunning.compareAndSet(true, false);
    }
}

