/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.dag;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.dag.Node;
import org.apache.servicecomb.saga.core.dag.SingleLeafDirectedAcyclicGraph;
import org.apache.servicecomb.saga.core.dag.Traveller;
import org.apache.servicecomb.saga.core.dag.TraversalDirection;

@EnableKamon
public class ByLevelTraveller<T>
implements Traveller<T> {
    private final Collection<Node<T>> nodes;
    private final Collection<Node<T>> nodesBuffer;
    private final Queue<Node<T>> nodesWithoutParent = new LinkedList<Node<T>>();
    private final Map<Long, Set<Node<T>>> nodeParents = new HashMap<Long, Set<Node<T>>>();
    private final TraversalDirection<T> traversalDirection;

    public ByLevelTraveller(SingleLeafDirectedAcyclicGraph<T> dag, TraversalDirection<T> traversalDirection) {
        this.nodes = new LinkedHashSet<Node<T>>();
        this.nodesBuffer = new LinkedList<Node<T>>();
        this.traversalDirection = traversalDirection;
        this.nodesWithoutParent.offer(traversalDirection.root(dag));
    }

    @Override
    @Segment(name="travelNext", category="application", library="kamon")
    public void next() {
        this.nodes.addAll(this.nodesBuffer);
        this.nodesBuffer.clear();
        boolean buffered = false;
        while (!this.nodesWithoutParent.isEmpty() && !buffered) {
            Node<T> node = this.nodesWithoutParent.poll();
            this.nodes.add(node);
            for (Node<T> child : this.traversalDirection.children(node)) {
                if (this.nodeParents.get(child.id()) == null) {
                    this.nodeParents.put(child.id(), new HashSet<Node<T>>(this.traversalDirection.parents(child)));
                }
                this.nodeParents.get(child.id()).remove(node);
                if (!this.nodeParents.get(child.id()).isEmpty()) continue;
                this.nodesWithoutParent.offer(child);
                this.nodesBuffer.add(child);
                buffered = true;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return !this.nodesWithoutParent.isEmpty();
    }

    @Override
    public Collection<Node<T>> nodes() {
        return this.nodes;
    }
}

