/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.application.interpreter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RestRequestChecker {
    private static final Set<String> validMethods = new HashSet<String>(Arrays.asList("GET", "POST", "PUT", "DELETE"));

    private RestRequestChecker() {
    }

    public static void checkParameters(String method, Map<String, Map<String, String>> params) {
        if (method == null || !validMethods.contains(method.toUpperCase())) {
            throw new IllegalArgumentException("Unsupported method " + method);
        }
        if (RestRequestChecker.isDeleteOrGet(method) && RestRequestChecker.hasBody(params)) {
            throw new IllegalArgumentException("GET & DELETE request cannot enclose a body");
        }
    }

    private static boolean isDeleteOrGet(String method) {
        return "GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method);
    }

    private static boolean hasBody(Map<String, Map<String, String>> params) {
        return params != null && (params.containsKey("form") || params.containsKey("json"));
    }
}

