/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.application;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.EventEnvelope;
import org.apache.servicecomb.saga.core.PersistentStore;
import org.apache.servicecomb.saga.core.Saga;
import org.apache.servicecomb.saga.core.SagaDefinition;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.ToJsonFormat;
import org.apache.servicecomb.saga.core.application.SagaFactory;
import org.apache.servicecomb.saga.core.application.interpreter.FromJsonFormat;
import org.apache.servicecomb.saga.infrastructure.EmbeddedEventStore;

@EnableKamon
public class SagaExecutionComponent {
    private final PersistentStore persistentStore;
    private final FromJsonFormat<SagaDefinition> fromJsonFormat;
    private final ToJsonFormat toJsonFormat;
    private final SagaFactory sagaFactory;

    public SagaExecutionComponent(PersistentStore persistentStore, FromJsonFormat<SagaDefinition> fromJsonFormat, ToJsonFormat toJsonFormat, SagaFactory sagaFactory) {
        this.persistentStore = persistentStore;
        this.fromJsonFormat = fromJsonFormat;
        this.toJsonFormat = toJsonFormat;
        this.sagaFactory = sagaFactory;
    }

    @Segment(name="runSagaExecutionComponent", category="application", library="kamon")
    public SagaResponse run(String requestJson) {
        String sagaId = UUID.randomUUID().toString();
        EmbeddedEventStore sagaLog = new EmbeddedEventStore();
        SagaDefinition definition = this.fromJsonFormat.fromJson(requestJson);
        Saga saga = this.sagaFactory.createSaga(requestJson, sagaId, sagaLog, definition);
        return saga.run();
    }

    public void reanimate() {
        Map<String, List<EventEnvelope>> pendingSagaEvents = this.persistentStore.findPendingSagaEvents();
        for (Map.Entry<String, List<EventEnvelope>> entry : pendingSagaEvents.entrySet()) {
            EmbeddedEventStore eventStore = new EmbeddedEventStore();
            eventStore.populate((Iterable<EventEnvelope>)entry.getValue());
            SagaEvent event = entry.getValue().iterator().next().event;
            String requestJson = event.json(this.toJsonFormat);
            SagaDefinition definition = this.fromJsonFormat.fromJson(requestJson);
            Saga saga = this.sagaFactory.createSaga(requestJson, event.sagaId, eventStore, definition);
            saga.play();
            saga.run();
        }
    }

    public void terminate() throws Exception {
        this.sagaFactory.terminate();
    }
}

