/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import kamon.annotation.Trace;
import org.apache.servicecomb.saga.core.Operation;
import org.apache.servicecomb.saga.core.SagaContext;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaStartFailedException;
import org.apache.servicecomb.saga.core.SagaTask;
import org.apache.servicecomb.saga.core.TaskConsumer;
import org.apache.servicecomb.saga.core.TransactionAbortedException;
import org.apache.servicecomb.saga.core.TransactionFailedException;
import org.apache.servicecomb.saga.core.dag.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnableKamon
class TransactionTaskConsumer
implements TaskConsumer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, SagaTask> tasks;
    private final SagaContext sagaContext;
    private final CompletionService<Operation> executorService;

    TransactionTaskConsumer(Map<String, SagaTask> tasks, SagaContext sagaContext, CompletionService<Operation> executorService) {
        this.tasks = tasks;
        this.sagaContext = sagaContext;
        this.executorService = executorService;
    }

    @Override
    @Segment(name="consumeTask", category="application", library="kamon")
    public void consume(Collection<Node<SagaRequest>> nodes) {
        ArrayList<Future<Operation>> futures = new ArrayList<Future<Operation>>(nodes.size());
        for (Node<SagaRequest> node : nodes) {
            SagaRequest request = node.value();
            if (!this.sagaContext.isChosenChild(request)) continue;
            futures.add(this.futureOf(request));
        }
        for (int i = 0; i < futures.size(); ++i) {
            try {
                this.executorService.take().get();
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof SagaStartFailedException) {
                    throw (SagaStartFailedException)e.getCause();
                }
                if (e.getCause() instanceof TransactionAbortedException) {
                    throw (TransactionAbortedException)e.getCause();
                }
                throw new TransactionFailedException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new TransactionFailedException(e);
            }
        }
    }

    @Override
    public boolean replay(Collection<Node<SagaRequest>> nodes) {
        Iterator<Node<SagaRequest>> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            SagaRequest request = iterator.next().value();
            if (!this.sagaContext.isTransactionCompleted(request)) continue;
            log.info("Skipped completed transaction id={} operation={} while replay", (Object)request.id(), (Object)request.transaction());
            iterator.remove();
        }
        return !nodes.isEmpty();
    }

    @Segment(name="submitCallable", category="application", library="kamon")
    private Future<Operation> futureOf(SagaRequest request) {
        return this.executorService.submit(new OperationCallable(this.tasks, request, this.sagaContext.responseOf(request.parents())));
    }

    @EnableKamon
    private static class OperationCallable
    implements Callable<Operation> {
        private final SagaRequest request;
        private final Map<String, SagaTask> tasks;
        private final SagaResponse parentResponse;

        private OperationCallable(Map<String, SagaTask> tasks, SagaRequest request, SagaResponse parentResponse) {
            this.request = request;
            this.tasks = tasks;
            this.parentResponse = parentResponse;
        }

        @Override
        @Trace(value="runTransactionCallable")
        public Operation call() throws Exception {
            this.tasks.get(this.request.task()).commit(this.request, this.parentResponse);
            return this.request.transaction();
        }
    }
}

