/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import org.apache.servicecomb.saga.core.EventContext;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.ToJsonFormat;

public class TransactionEndedEvent
extends SagaEvent {
    private final SagaResponse response;

    public TransactionEndedEvent(String sagaId, SagaRequest request) {
        this(sagaId, request, SagaResponse.EMPTY_RESPONSE);
    }

    public TransactionEndedEvent(String sagaId, SagaRequest request, SagaResponse response) {
        super(sagaId, request);
        this.response = response;
    }

    @Override
    public void gatherTo(EventContext sagaContext) {
        sagaContext.endTransaction(this.payload(), this.response);
    }

    public String toString() {
        return "TransactionEndedEvent{id=" + this.payload().id() + ", sagaId=" + this.sagaId + ", operation=" + this.payload().transaction() + "}";
    }

    @Override
    public String json(ToJsonFormat toJsonFormat) {
        return toJsonFormat.toJson(this.payload(), this.response);
    }

    public SagaResponse response() {
        return this.response;
    }
}

