/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import org.apache.servicecomb.saga.core.EventContext;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.ToJsonFormat;

public class TransactionCompensatedEvent
extends SagaEvent {
    private final SagaResponse response;

    public TransactionCompensatedEvent(String sagaId, SagaRequest request) {
        this(sagaId, request, SagaResponse.EMPTY_RESPONSE);
    }

    public TransactionCompensatedEvent(String sagaId, SagaRequest request, SagaResponse response) {
        super(sagaId, request);
        this.response = response;
    }

    @Override
    public void gatherTo(EventContext sagaContext) {
        sagaContext.compensateTransaction(this.payload(), this.response);
    }

    @Override
    public String json(ToJsonFormat toJsonFormat) {
        return toJsonFormat.toJson(this.payload(), this.response);
    }

    public String toString() {
        return "TransactionCompensatedEvent{id=" + this.payload().id() + ", sagaId=" + this.sagaId + ", operation=" + this.payload().compensation() + "}";
    }

    public SagaResponse response() {
        return this.response;
    }
}

