/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import org.apache.servicecomb.saga.core.EventContext;
import org.apache.servicecomb.saga.core.FailedSagaResponse;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.ToJsonFormat;

public class TransactionAbortedEvent
extends SagaEvent {
    private final SagaResponse response;

    public TransactionAbortedEvent(String sagaId, SagaRequest payload, Exception exception) {
        super(sagaId, payload);
        this.response = new FailedSagaResponse(exception);
    }

    public TransactionAbortedEvent(String sagaId, SagaRequest payload, SagaResponse response) {
        super(sagaId, payload);
        this.response = response;
    }

    @Override
    public void gatherTo(EventContext sagaContext) {
        sagaContext.abortTransaction(this.payload(), this.response);
    }

    @Override
    public String json(ToJsonFormat toJsonFormat) {
        return toJsonFormat.toJson(this.payload(), this.response);
    }

    public String toString() {
        return "TransactionAbortedEvent{id=" + this.payload().id() + ", operation=" + this.payload().compensation() + "}";
    }

    public SagaResponse response() {
        return this.response;
    }
}

