/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.util.Collection;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaState;
import org.apache.servicecomb.saga.core.TaskConsumer;
import org.apache.servicecomb.saga.core.dag.Node;
import org.apache.servicecomb.saga.core.dag.Traveller;

@EnableKamon
class TaskRunner
implements SagaState {
    private final Traveller<SagaRequest> traveller;
    private final TaskConsumer taskConsumer;

    TaskRunner(Traveller<SagaRequest> traveller, TaskConsumer taskConsumer) {
        this.traveller = traveller;
        this.taskConsumer = taskConsumer;
    }

    @Override
    public boolean hasNext() {
        return this.traveller.hasNext();
    }

    @Override
    @Segment(name="runTask", category="application", library="kamon")
    public void run() {
        Collection<Node<SagaRequest>> nodes = this.traveller.nodes();
        if (!nodes.isEmpty()) {
            this.taskConsumer.consume(nodes);
            nodes.clear();
        }
        while (this.traveller.hasNext()) {
            this.traveller.next();
            this.taskConsumer.consume(nodes);
            nodes.clear();
        }
    }

    @Override
    public void replay() {
        boolean played = false;
        Collection<Node<SagaRequest>> nodes = this.traveller.nodes();
        while (this.traveller.hasNext() && !played) {
            this.traveller.next();
            played = this.taskConsumer.replay(nodes);
        }
    }
}

