/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.saga.core.CompositeSagaLog;
import org.apache.servicecomb.saga.core.EventStore;
import org.apache.servicecomb.saga.core.FallbackPolicy;
import org.apache.servicecomb.saga.core.LoggingRecoveryPolicy;
import org.apache.servicecomb.saga.core.PersistentLog;
import org.apache.servicecomb.saga.core.PersistentStore;
import org.apache.servicecomb.saga.core.RecoveryPolicy;
import org.apache.servicecomb.saga.core.RequestProcessTask;
import org.apache.servicecomb.saga.core.SagaEndTask;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.apache.servicecomb.saga.core.SagaLog;
import org.apache.servicecomb.saga.core.SagaStartTask;
import org.apache.servicecomb.saga.core.SagaTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaTaskFactory {
    private final FallbackPolicy fallbackPolicy;
    private final RetrySagaLog retrySagaLog;
    private final PersistentStore persistentStore;

    public SagaTaskFactory(int retryDelay, PersistentStore persistentStore) {
        this.persistentStore = persistentStore;
        this.fallbackPolicy = new FallbackPolicy(retryDelay);
        this.retrySagaLog = new RetrySagaLog(persistentStore, retryDelay);
    }

    public Map<String, SagaTask> sagaTasks(final String sagaId, final String requestJson, final RecoveryPolicy recoveryPolicy, final EventStore sagaLog) {
        final CompositeSagaLog compositeSagaLog = this.compositeSagaLog(sagaLog, this.persistentStore);
        return new HashMap<String, SagaTask>(){
            {
                this.put("SagaStart", new SagaStartTask(sagaId, requestJson, compositeSagaLog));
                CompositeSagaLog retrySagaLog = SagaTaskFactory.this.compositeSagaLog(sagaLog, SagaTaskFactory.this.retrySagaLog);
                this.put("SagaRequest", new RequestProcessTask(sagaId, retrySagaLog, new LoggingRecoveryPolicy(recoveryPolicy), SagaTaskFactory.this.fallbackPolicy));
                this.put("SagaEnd", new SagaEndTask(sagaId, retrySagaLog));
            }
        };
    }

    private CompositeSagaLog compositeSagaLog(SagaLog sagaLog, PersistentLog persistentLog) {
        return new CompositeSagaLog(sagaLog, persistentLog);
    }

    static class RetrySagaLog
    implements PersistentLog {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private final PersistentStore persistentStore;
        private final int retryDelay;

        RetrySagaLog(PersistentStore persistentStore, int retryDelay) {
            this.persistentStore = persistentStore;
            this.retryDelay = retryDelay;
        }

        @Override
        public void offer(SagaEvent sagaEvent) {
            boolean success = false;
            do {
                try {
                    this.persistentStore.offer(sagaEvent);
                    success = true;
                    log.info("Persisted saga event {} successfully", (Object)sagaEvent);
                }
                catch (Exception e) {
                    log.error("Failed to persist saga event {}", (Object)sagaEvent, (Object)e);
                    this.sleep(this.retryDelay);
                }
            } while (!success && !this.isInterrupted());
        }

        private boolean isInterrupted() {
            return Thread.currentThread().isInterrupted();
        }

        private void sleep(int delay) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

