/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.SagaEndedEvent;
import org.apache.servicecomb.saga.core.SagaLog;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaStartFailedException;
import org.apache.servicecomb.saga.core.SagaStartedEvent;
import org.apache.servicecomb.saga.core.SagaTask;

@EnableKamon
public class SagaStartTask
implements SagaTask {
    private final String sagaId;
    private final String requestJson;
    private final SagaLog sagaLog;

    public SagaStartTask(String sagaId, String requestJson, SagaLog sagaLog) {
        this.sagaId = sagaId;
        this.requestJson = requestJson;
        this.sagaLog = sagaLog;
    }

    @Override
    @Segment(name="startTaskCommit", category="application", library="kamon")
    public SagaResponse commit(SagaRequest request, SagaResponse parentResponse) {
        try {
            this.sagaLog.offer(new SagaStartedEvent(this.sagaId, this.requestJson, request));
        }
        catch (Exception e) {
            throw new SagaStartFailedException("Failed to persist SagaStartedEvent for " + this.requestJson, e);
        }
        return SagaResponse.EMPTY_RESPONSE;
    }

    @Override
    public void compensate(SagaRequest request) {
        this.sagaLog.offer(new SagaEndedEvent(this.sagaId, request));
    }

    @Override
    public void abort(SagaRequest request, Exception e) {
    }
}

