/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.util.Arrays;
import org.apache.servicecomb.saga.core.Compensation;
import org.apache.servicecomb.saga.core.Fallback;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.Transaction;

public class SagaRequestImpl
implements SagaRequest {
    private final String id;
    private final String serviceName;
    private final String type;
    private final Transaction transaction;
    private final Compensation compensation;
    private final String[] parents;
    private final Fallback fallback;
    private final int failRetryDelayMilliseconds;

    public SagaRequestImpl(String id, String serviceName, String type, Transaction transaction, Compensation compensation, Fallback fallback, String[] parents, int failRetryDelayMilliseconds) {
        this.id = id;
        this.serviceName = serviceName;
        this.type = type;
        this.transaction = transaction;
        this.compensation = compensation;
        this.fallback = fallback;
        this.failRetryDelayMilliseconds = failRetryDelayMilliseconds <= 0 ? 50 : failRetryDelayMilliseconds;
        this.parents = parents == null ? new String[]{} : parents;
    }

    public SagaRequestImpl(String id, String serviceName, String type, Transaction transaction, Compensation compensation, Fallback fallback, String[] parents) {
        this(id, serviceName, type, transaction, compensation, fallback, parents, 0);
    }

    public SagaRequestImpl(String id, String serviceName, String type, Transaction transaction, Compensation compensation, Fallback fallback) {
        this(id, serviceName, type, transaction, compensation, fallback, new String[0]);
    }

    public SagaRequestImpl(String id, String serviceName, String type, Transaction transaction, Compensation compensation) {
        this(id, serviceName, type, transaction, compensation, Fallback.NOP_FALLBACK, new String[0]);
    }

    public SagaRequestImpl(String id, String serviceName, String type, Transaction transaction, Compensation compensation, String[] parents) {
        this(id, serviceName, type, transaction, compensation, Fallback.NOP_FALLBACK, parents);
    }

    @Override
    public Transaction transaction() {
        return this.transaction;
    }

    @Override
    public Compensation compensation() {
        return this.compensation;
    }

    @Override
    public Fallback fallback() {
        return this.fallback;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String task() {
        return "SagaRequest";
    }

    @Override
    public String[] parents() {
        return this.parents;
    }

    @Override
    public int failRetryDelayMilliseconds() {
        return this.failRetryDelayMilliseconds;
    }

    public String toString() {
        return "SagaRequest{id='" + this.id + '\'' + ", serviceName='" + this.serviceName + '\'' + ", type='" + this.type + '\'' + ", transaction=" + this.transaction + ", compensation=" + this.compensation + ", fallback=" + this.fallback + ", parents=" + Arrays.toString(this.parents) + '}';
    }
}

