/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.servicecomb.saga.core.CompositeSagaResponse;
import org.apache.servicecomb.saga.core.SagaContext;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.TransactionConsumer;
import org.apache.servicecomb.saga.core.application.interpreter.FromJsonFormat;

public class SagaContextImpl
implements SagaContext {
    private final Map<String, SagaResponse> completedTransactions;
    private final Map<String, SagaResponse> completedCompensations;
    private final Set<String> abortedTransactions;
    private final Map<String, SagaRequest> hangingTransactions;
    private final FromJsonFormat<Set<String>> childrenExtractor;

    public SagaContextImpl(FromJsonFormat<Set<String>> childrenExtractor) {
        this.childrenExtractor = childrenExtractor;
        this.completedTransactions = new ConcurrentHashMap<String, SagaResponse>();
        this.completedCompensations = new HashMap<String, SagaResponse>();
        this.abortedTransactions = new ConcurrentSkipListSet<String>();
        this.hangingTransactions = new ConcurrentHashMap<String, SagaRequest>();
    }

    @Override
    public boolean isCompensationStarted() {
        return !this.abortedTransactions.isEmpty() || !this.completedCompensations.isEmpty();
    }

    @Override
    public boolean isTransactionCompleted(SagaRequest request) {
        return this.completedTransactions.containsKey(request.id());
    }

    @Override
    public boolean isCompensationCompleted(SagaRequest request) {
        return this.completedCompensations.containsKey(request.id());
    }

    @Override
    public void beginTransaction(SagaRequest request) {
        this.hangingTransactions.put(request.id(), request);
    }

    @Override
    public void endTransaction(SagaRequest request, SagaResponse response) {
        this.completedTransactions.put(request.id(), response);
        this.hangingTransactions.remove(request.id());
    }

    @Override
    public void abortTransaction(SagaRequest request, SagaResponse response) {
        this.completedTransactions.remove(request.id());
        this.abortedTransactions.add(request.id());
        this.hangingTransactions.remove(request.id());
    }

    @Override
    public void compensateTransaction(SagaRequest request, SagaResponse response) {
        this.completedCompensations.put(request.id(), response);
        this.completedTransactions.remove(request.id());
    }

    @Override
    public void handleHangingTransactions(TransactionConsumer<SagaRequest> consumer) {
        Iterator<SagaRequest> iterator = this.hangingTransactions.values().iterator();
        while (iterator.hasNext()) {
            consumer.accept(iterator.next());
        }
    }

    @Override
    public SagaResponse responseOf(String requestId) {
        SagaResponse response = this.completedTransactions.get(requestId);
        if (response == null) {
            response = SagaResponse.NONE_RESPONSE;
        }
        return response;
    }

    private List<SagaResponse> responsesOf(String[] parentRequestIds) {
        ArrayList<SagaResponse> result = new ArrayList<SagaResponse>();
        for (String parentRequestId : parentRequestIds) {
            result.add(this.responseOf(parentRequestId));
        }
        return result;
    }

    @Override
    public SagaResponse responseOf(String[] parentRequestIds) {
        List<SagaResponse> responses = this.responsesOf(parentRequestIds);
        if (responses.isEmpty()) {
            return SagaResponse.EMPTY_RESPONSE;
        }
        if (responses.size() == 1) {
            return responses.get(0);
        }
        return new CompositeSagaResponse(responses);
    }

    @Override
    public boolean isChosenChild(SagaRequest request) {
        Set<String> chosenChildren = this.chosenChildrenOf(request.parents());
        return chosenChildren.isEmpty() || chosenChildren.contains(request.id());
    }

    private Set<String> chosenChildrenOf(String[] parentRequestIds) {
        HashSet<String> result = new HashSet<String>();
        for (String parentRequestId : parentRequestIds) {
            SagaResponse response = this.responseOf(parentRequestId);
            Set<String> jsons = this.childrenExtractor.fromJson(response.body());
            for (String json : jsons) {
                result.add(json);
            }
        }
        return result;
    }
}

