/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.util.Collections;
import java.util.Map;
import org.apache.servicecomb.saga.core.Operation;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.application.interpreter.RestRequestChecker;

public class RestOperation
implements Operation {
    private final String path;
    private final String method;
    private final int retries;
    private final Map<String, Map<String, String>> params;

    public RestOperation(String path, String method, Map<String, Map<String, String>> params) {
        this(path, method, 3, params);
    }

    public RestOperation(String path, String method, int retries, Map<String, Map<String, String>> params) {
        RestRequestChecker.checkParameters(method, params);
        this.path = path;
        this.method = method;
        this.retries = retries;
        this.params = params == null ? Collections.emptyMap() : params;
    }

    public String path() {
        return this.path;
    }

    public String method() {
        return this.method;
    }

    public Map<String, Map<String, String>> params() {
        return this.params;
    }

    public String toString() {
        return "Operation{path='" + this.path + '\'' + ", method='" + this.method + '\'' + ", params=" + this.params + '}';
    }

    @Override
    public SagaResponse send(String address) {
        return SUCCESSFUL_SAGA_RESPONSE;
    }

    @Override
    public SagaResponse send(String address, SagaResponse response) {
        return this.send(address);
    }

    @Override
    public int retries() {
        return this.retries;
    }
}

