/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.Compensation;
import org.apache.servicecomb.saga.core.FallbackPolicy;
import org.apache.servicecomb.saga.core.RecoveryPolicy;
import org.apache.servicecomb.saga.core.SagaLog;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaTask;
import org.apache.servicecomb.saga.core.TransactionAbortedEvent;
import org.apache.servicecomb.saga.core.TransactionCompensatedEvent;
import org.apache.servicecomb.saga.core.TransactionEndedEvent;
import org.apache.servicecomb.saga.core.TransactionStartedEvent;

@EnableKamon
public class RequestProcessTask
implements SagaTask {
    private final String sagaId;
    private final SagaLog sagaLog;
    private final RecoveryPolicy recoveryPolicy;
    private final FallbackPolicy fallbackPolicy;

    public RequestProcessTask(String sagaId, SagaLog sagaLog, RecoveryPolicy recoveryPolicy, FallbackPolicy fallbackPolicy) {
        this.sagaId = sagaId;
        this.sagaLog = sagaLog;
        this.recoveryPolicy = recoveryPolicy;
        this.fallbackPolicy = fallbackPolicy;
    }

    @Override
    @Segment(name="commit", category="application", library="kamon")
    public SagaResponse commit(SagaRequest request, SagaResponse parentResponse) {
        this.sagaLog.offer(new TransactionStartedEvent(this.sagaId, request));
        SagaResponse response = this.recoveryPolicy.apply(this, request, parentResponse);
        this.sagaLog.offer(new TransactionEndedEvent(this.sagaId, request, response));
        return response;
    }

    @Override
    @Segment(name="compensate", category="application", library="kamon")
    public void compensate(SagaRequest request) {
        Compensation compensation = request.compensation();
        SagaResponse response = this.fallbackPolicy.apply(request.serviceName(), compensation, request.fallback());
        this.sagaLog.offer(new TransactionCompensatedEvent(this.sagaId, request, response));
    }

    @Override
    public void abort(SagaRequest request, Exception e) {
        this.sagaLog.offer(new TransactionAbortedEvent(this.sagaId, request, e));
    }
}

