/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.lang.invoke.MethodHandles;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.RecoveryPolicy;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnableKamon
public class LoggingRecoveryPolicy
implements RecoveryPolicy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RecoveryPolicy recoveryPolicy;

    public LoggingRecoveryPolicy(RecoveryPolicy recoveryPolicy) {
        this.recoveryPolicy = recoveryPolicy;
    }

    @Override
    @Segment(name="loggingPolicy", category="application", library="kamon")
    public SagaResponse apply(SagaTask task, SagaRequest request, SagaResponse parentResponse) {
        log.info("Starting request id={} for service {}", (Object)request.id(), (Object)request.serviceName());
        SagaResponse response = this.recoveryPolicy.apply(task, request, parentResponse);
        log.info("Completed request id={} for service {}", (Object)request.id(), (Object)request.serviceName());
        return response;
    }

    @Override
    public String description() {
        return this.getClass().getSimpleName();
    }
}

