/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.CompensationTaskConsumer;
import org.apache.servicecomb.saga.core.EventStore;
import org.apache.servicecomb.saga.core.FailedSagaResponse;
import org.apache.servicecomb.saga.core.Operation;
import org.apache.servicecomb.saga.core.Saga;
import org.apache.servicecomb.saga.core.SagaContext;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaState;
import org.apache.servicecomb.saga.core.SagaTask;
import org.apache.servicecomb.saga.core.TaskRunner;
import org.apache.servicecomb.saga.core.TransactionAbortedException;
import org.apache.servicecomb.saga.core.TransactionConsumer;
import org.apache.servicecomb.saga.core.TransactionFailedException;
import org.apache.servicecomb.saga.core.TransactionTaskConsumer;
import org.apache.servicecomb.saga.core.dag.ByLevelTraveller;
import org.apache.servicecomb.saga.core.dag.FromLeafTraversalDirection;
import org.apache.servicecomb.saga.core.dag.FromRootTraversalDirection;
import org.apache.servicecomb.saga.core.dag.SingleLeafDirectedAcyclicGraph;
import org.apache.servicecomb.saga.core.dag.TraversalDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnableKamon
public class GraphBasedSaga
implements Saga {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final EventStore eventStore;
    private final Map<String, SagaTask> tasks;
    private final TaskRunner transactionTaskRunner;
    private final TaskRunner compensationTaskRunner;
    private final SagaContext sagaContext;
    private volatile SagaState currentTaskRunner;

    GraphBasedSaga(EventStore eventStore, Map<String, SagaTask> tasks, SagaContext sagaContext, SingleLeafDirectedAcyclicGraph<SagaRequest> sagaTaskGraph) {
        this(eventStore, Executors.newFixedThreadPool(5), tasks, sagaContext, sagaTaskGraph);
    }

    public GraphBasedSaga(EventStore eventStore, Executor executor, Map<String, SagaTask> tasks, SagaContext sagaContext, SingleLeafDirectedAcyclicGraph<SagaRequest> sagaTaskGraph) {
        this.eventStore = eventStore;
        this.tasks = tasks;
        this.transactionTaskRunner = new TaskRunner(this.traveller(sagaTaskGraph, new FromRootTraversalDirection<SagaRequest>()), new TransactionTaskConsumer(tasks, sagaContext, new ExecutorCompletionService<Operation>(executor)));
        this.sagaContext = sagaContext;
        this.compensationTaskRunner = new TaskRunner(this.traveller(sagaTaskGraph, new FromLeafTraversalDirection<SagaRequest>()), new CompensationTaskConsumer(tasks, sagaContext));
        this.currentTaskRunner = this.transactionTaskRunner;
    }

    @Override
    @Segment(name="runSaga", category="application", library="kamon")
    public SagaResponse run() {
        SagaResponse response = SagaResponse.EMPTY_RESPONSE;
        log.info("Starting Saga");
        do {
            try {
                this.currentTaskRunner.run();
            }
            catch (TransactionFailedException e) {
                response = new FailedSagaResponse(e);
                log.error("Failed to run operation", (Throwable)e);
                this.currentTaskRunner = this.compensationTaskRunner;
                this.sagaContext.handleHangingTransactions(new TransactionConsumer<SagaRequest>(){

                    @Override
                    public void accept(SagaRequest request) {
                        ((SagaTask)GraphBasedSaga.this.tasks.get(request.task())).commit(request, GraphBasedSaga.this.sagaContext.responseOf(request.parents()));
                        ((SagaTask)GraphBasedSaga.this.tasks.get(request.task())).compensate(request);
                    }
                });
            }
            catch (TransactionAbortedException e) {
                response = new FailedSagaResponse(e);
                log.error("Transaction aborted ", (Throwable)e);
                break;
            }
        } while (this.currentTaskRunner.hasNext());
        log.info("Completed Saga");
        return response;
    }

    @Override
    public void play() {
        log.info("Start playing events");
        this.gatherEvents(this.eventStore);
        this.transactionTaskRunner.replay();
        if (this.sagaContext.isCompensationStarted()) {
            this.currentTaskRunner = this.compensationTaskRunner;
            this.compensationTaskRunner.replay();
        }
        log.info("Completed playing events");
    }

    private void gatherEvents(Iterable<SagaEvent> events) {
        for (SagaEvent event : events) {
            event.gatherTo(this.sagaContext);
        }
    }

    private ByLevelTraveller<SagaRequest> traveller(SingleLeafDirectedAcyclicGraph<SagaRequest> sagaTaskGraph, TraversalDirection<SagaRequest> traversalDirection) {
        return new ByLevelTraveller<SagaRequest>(sagaTaskGraph, traversalDirection);
    }
}

