/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.saga.core.RecoveryPolicy;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaTask;
import org.apache.servicecomb.saga.core.Transaction;
import org.apache.servicecomb.saga.core.TransactionAbortedException;
import org.apache.servicecomb.saga.core.TransactionFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardRecovery
implements RecoveryPolicy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public SagaResponse apply(SagaTask task, SagaRequest request, SagaResponse parentResponse) {
        try {
            int i = 0;
            while (this.isRetryable(i, request.transaction())) {
                try {
                    return request.transaction().send(request.serviceName(), parentResponse);
                }
                catch (Exception e) {
                    log.error("Applying {} policy due to failure in transaction {} of service {}", new Object[]{this.description(), request.transaction(), request.serviceName(), e});
                    Thread.sleep(request.failRetryDelayMilliseconds());
                    ++i;
                }
            }
        }
        catch (InterruptedException ignored) {
            log.warn("Applying {} interrupted in transaction {} of service {}", new Object[]{this.description(), request.transaction(), request.serviceName(), ignored});
            throw new TransactionFailedException(ignored);
        }
        throw new TransactionAbortedException(String.format("Too many failures in transaction %s of service %s, abort the transaction!", request.transaction(), request.serviceName()));
    }

    private boolean isRetryable(int i, Transaction transaction) {
        return transaction.retries() <= 0 || i <= transaction.retries();
    }

    @Override
    public String description() {
        return this.getClass().getSimpleName();
    }
}

