/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.saga.core.Compensation;
import org.apache.servicecomb.saga.core.Fallback;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackPolicy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int retryDelay;

    public FallbackPolicy(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public SagaResponse apply(String address, Compensation compensation, Fallback fallback) {
        int i = 0;
        while (this.isRetryable(i, compensation) && !this.isInterrupted()) {
            try {
                return compensation.send(address);
            }
            catch (Exception e) {
                log.error("Failed to send compensation to {}", (Object)address, (Object)e);
                this.sleep(this.retryDelay);
                ++i;
            }
        }
        log.warn("Falling back after {} failures sending compensation to {}", (Object)compensation.retries(), (Object)address);
        return fallback.send(address);
    }

    private boolean isRetryable(int i, Compensation compensation) {
        return compensation.retries() < 0 || i <= compensation.retries();
    }

    private boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    private void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

