/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.util.Collection;
import org.apache.servicecomb.saga.core.SagaResponse;

public class CompositeSagaResponse
implements SagaResponse {
    private final Collection<SagaResponse> responses;

    public CompositeSagaResponse(Collection<SagaResponse> responses) {
        this.responses = responses;
    }

    @Override
    public boolean succeeded() {
        if (this.responses.size() > 0) {
            boolean result = true;
            for (SagaResponse response : this.responses) {
                result = result && response.succeeded();
            }
            return result;
        }
        return false;
    }

    @Override
    public String body() {
        StringBuffer result = new StringBuffer();
        if (this.responses.size() == 0) {
            result.append("{}");
        } else {
            result.append("[");
            for (SagaResponse response : this.responses) {
                result.append(response.body());
                result.append(", ");
            }
            result.delete(result.length() - 2, result.length());
            result.append("]");
        }
        return result.toString();
    }

    public Collection<SagaResponse> responses() {
        return this.responses;
    }
}

