/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.servicecomb.saga.core.SagaContext;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaTask;
import org.apache.servicecomb.saga.core.TaskConsumer;
import org.apache.servicecomb.saga.core.dag.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompensationTaskConsumer
implements TaskConsumer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, SagaTask> tasks;
    private final SagaContext sagaContext;

    CompensationTaskConsumer(Map<String, SagaTask> tasks, SagaContext sagaContext) {
        this.tasks = tasks;
        this.sagaContext = sagaContext;
    }

    @Override
    public void consume(Collection<Node<SagaRequest>> nodes) {
        for (Node<SagaRequest> node : nodes) {
            SagaRequest request = node.value();
            if (!this.sagaContext.isTransactionCompleted(request)) continue;
            log.info("Starting request {} id={}", (Object)request.serviceName(), (Object)request.id());
            this.tasks.get(request.task()).compensate(request);
            log.info("Completed request {} id={}", (Object)request.serviceName(), (Object)request.id());
        }
    }

    @Override
    public boolean replay(Collection<Node<SagaRequest>> nodes) {
        Iterator<Node<SagaRequest>> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            SagaRequest request = iterator.next().value();
            if (this.sagaContext.isCompensationCompleted(request)) {
                log.info("Skipped completed compensation id={} operation={} while replay", (Object)request.id(), (Object)request.transaction());
                iterator.remove();
                continue;
            }
            if (this.sagaContext.isTransactionCompleted(request)) continue;
            log.info("Skipped pending transaction id={} operation={} while replay", (Object)request.id(), (Object)request.transaction());
            iterator.remove();
        }
        return !nodes.isEmpty();
    }
}

