/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core;

import java.lang.invoke.MethodHandles;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.RecoveryPolicy;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnableKamon
public class BackwardRecovery
implements RecoveryPolicy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @Segment(name="backwardPolicy", category="application", library="kamon")
    public SagaResponse apply(SagaTask task, SagaRequest request, SagaResponse parentResponse) {
        try {
            return request.transaction().send(request.serviceName(), parentResponse);
        }
        catch (Exception e) {
            log.error("Applying {} policy due to failure in transaction {} of service {}", new Object[]{this.description(), request.transaction(), request.serviceName(), e});
            task.abort(request, e);
            throw e;
        }
    }

    @Override
    public String description() {
        return this.getClass().getSimpleName();
    }
}

