/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.Stash;
import akka.actor.StashSupport;
import akka.actor.Status;
import akka.actor.SupervisorStrategy;
import akka.actor.UnrestrictedStash;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.dispatch.DequeBasedMessageQueueSemantics;
import akka.dispatch.Envelope;
import akka.event.LoggingAdapter;
import akka.io.IO$;
import akka.io.Udp;
import akka.io.Udp$;
import akka.io.Udp$Bind$;
import akka.io.Udp$Send$;
import akka.io.Udp$Unbind$;
import akka.io.Udp$Unbound$;
import akka.io.dns.RecordClass$;
import akka.io.dns.RecordType;
import akka.io.dns.RecordType$;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.DnsClient$;
import akka.io.dns.internal.Message;
import akka.io.dns.internal.Message$;
import akka.io.dns.internal.MessageFlags$;
import akka.io.dns.internal.Question;
import akka.io.dns.internal.ResponseCode$;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\r%vAB\u0001\u0003\u0011\u0003A!\"A\u0005E]N\u001cE.[3oi*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004I:\u001c(BA\u0004\t\u0003\tIwNC\u0001\n\u0003\u0011\t7n[1\u0011\u0005-aQ\"\u0001\u0002\u0007\r5\u0011\u0001\u0012\u0001\u0005\u000f\u0005%!en]\"mS\u0016tGo\u0005\u0002\r\u001fA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001aDQA\u0006\u0007\u0005\u0002a\ta\u0001P5oSRt4\u0001\u0001\u000b\u0002\u0015\u00199!\u0004\u0004I\u0001$CY\"a\u0003#ogF+Xm\u001d;j_:\u001c\"!G\b\t\u000buIb\u0011\u0001\u0010\u0002\u0005%$W#A\u0010\u0011\u0005A\u0001\u0013BA\u0011\u0012\u0005\u0015\u0019\u0006n\u001c:uS\u0019I2%!\b\u0002^\u0019!A\u0005\u0004\"&\u0005%\tV/Z:uS>tGgE\u0003$\u001f\u0019B3\u0006\u0005\u0002(35\tA\u0002\u0005\u0002\u0011S%\u0011!&\u0005\u0002\b!J|G-^2u!\t\u0001B&\u0003\u0002.#\ta1+\u001a:jC2L'0\u00192mK\"AQd\tBK\u0002\u0013\u0005a\u0004\u0003\u00051G\tE\t\u0015!\u0003 \u0003\rIG\r\t\u0005\te\r\u0012)\u001a!C\u0001g\u0005!a.Y7f+\u0005!\u0004CA\u001b=\u001d\t1$\b\u0005\u00028#5\t\u0001H\u0003\u0002:/\u00051AH]8pizJ!aO\t\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003wEA\u0001\u0002Q\u0012\u0003\u0012\u0003\u0006I\u0001N\u0001\u0006]\u0006lW\r\t\u0005\u0006-\r\"\tA\u0011\u000b\u0004\u0007\u0012+\u0005CA\u0014$\u0011\u0015i\u0012\t1\u0001 \u0011\u0015\u0011\u0014\t1\u00015\u0011\u001d95%!A\u0005\u0002!\u000bAaY8qsR\u00191)\u0013&\t\u000fu1\u0005\u0013!a\u0001?!9!G\u0012I\u0001\u0002\u0004!\u0004b\u0002'$#\u0003%\t!T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005q%FA\u0010PW\u0005\u0001\u0006CA)W\u001b\u0005\u0011&BA*U\u0003%)hn\u00195fG.,GM\u0003\u0002V#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]\u0013&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9\u0011lII\u0001\n\u0003Q\u0016AD2paf$C-\u001a4bk2$HEM\u000b\u00027*\u0012Ag\u0014\u0005\b;\u000e\n\t\u0011\"\u0011_\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tq\f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006!A.\u00198h\u0015\u0005!\u0017\u0001\u00026bm\u0006L!!P1\t\u000f\u001d\u001c\u0013\u0011!C\u0001Q\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t\u0011\u000e\u0005\u0002\u0011U&\u00111.\u0005\u0002\u0004\u0013:$\bbB7$\u0003\u0003%\tA\\\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ty'\u000f\u0005\u0002\u0011a&\u0011\u0011/\u0005\u0002\u0004\u0003:L\bbB:m\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0004bB;$\u0003\u0003%\tE^\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\tq\u000fE\u0002yw>l\u0011!\u001f\u0006\u0003uF\t!bY8mY\u0016\u001cG/[8o\u0013\ta\u0018P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u001dq8%!A\u0005\u0002}\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\t9\u0001E\u0002\u0011\u0003\u0007I1!!\u0002\u0012\u0005\u001d\u0011un\u001c7fC:Dqa]?\u0002\u0002\u0003\u0007q\u000eC\u0005\u0002\f\r\n\t\u0011\"\u0011\u0002\u000e\u0005A\u0001.Y:i\u0007>$W\rF\u0001j\u0011%\t\tbIA\u0001\n\u0003\n\u0019\"\u0001\u0005u_N#(/\u001b8h)\u0005y\u0006\"CA\fG\u0005\u0005I\u0011IA\r\u0003\u0019)\u0017/^1mgR!\u0011\u0011AA\u000e\u0011!\u0019\u0018QCA\u0001\u0002\u0004ygABA\u0010\u0019\t\u000b\tCA\u0005Rk\u0016\u001cH/[8omM1\u0011QD\b'Q-B\u0011\"HA\u000f\u0005+\u0007I\u0011\u0001\u0010\t\u0013A\niB!E!\u0002\u0013y\u0002\"\u0003\u001a\u0002\u001e\tU\r\u0011\"\u00014\u0011%\u0001\u0015Q\u0004B\tB\u0003%A\u0007C\u0004\u0017\u0003;!\t!!\f\u0015\r\u0005=\u0012\u0011GA\u001a!\r9\u0013Q\u0004\u0005\u0007;\u0005-\u0002\u0019A\u0010\t\rI\nY\u00031\u00015\u0011%9\u0015QDA\u0001\n\u0003\t9\u0004\u0006\u0004\u00020\u0005e\u00121\b\u0005\t;\u0005U\u0002\u0013!a\u0001?!A!'!\u000e\u0011\u0002\u0003\u0007A\u0007\u0003\u0005M\u0003;\t\n\u0011\"\u0001N\u0011!I\u0016QDI\u0001\n\u0003Q\u0006\u0002C/\u0002\u001e\u0005\u0005I\u0011\t0\t\u0011\u001d\fi\"!A\u0005\u0002!D\u0011\"\\A\u000f\u0003\u0003%\t!a\u0012\u0015\u0007=\fI\u0005\u0003\u0005t\u0003\u000b\n\t\u00111\u0001j\u0011!)\u0018QDA\u0001\n\u00032\b\"\u0003@\u0002\u001e\u0005\u0005I\u0011AA()\u0011\t\t!!\u0015\t\u0011M\fi%!AA\u0002=D!\"a\u0003\u0002\u001e\u0005\u0005I\u0011IA\u0007\u0011)\t\t\"!\b\u0002\u0002\u0013\u0005\u00131\u0003\u0005\u000b\u0003/\ti\"!A\u0005B\u0005eC\u0003BA\u0001\u00037B\u0001b]A,\u0003\u0003\u0005\ra\u001c\u0004\u0007\u0003?b!)!\u0019\u0003\u0017M\u0013h/U;fgRLwN\\\n\u0007\u0003;za\u0005K\u0016\t\u0013u\tiF!f\u0001\n\u0003q\u0002\"\u0003\u0019\u0002^\tE\t\u0015!\u0003 \u0011%\u0011\u0014Q\fBK\u0002\u0013\u00051\u0007C\u0005A\u0003;\u0012\t\u0012)A\u0005i!9a#!\u0018\u0005\u0002\u00055DCBA8\u0003c\n\u0019\bE\u0002(\u0003;Ba!HA6\u0001\u0004y\u0002B\u0002\u001a\u0002l\u0001\u0007A\u0007C\u0005H\u0003;\n\t\u0011\"\u0001\u0002xQ1\u0011qNA=\u0003wB\u0001\"HA;!\u0003\u0005\ra\b\u0005\te\u0005U\u0004\u0013!a\u0001i!AA*!\u0018\u0012\u0002\u0013\u0005Q\n\u0003\u0005Z\u0003;\n\n\u0011\"\u0001[\u0011!i\u0016QLA\u0001\n\u0003r\u0006\u0002C4\u0002^\u0005\u0005I\u0011\u00015\t\u00135\fi&!A\u0005\u0002\u0005\u001dEcA8\u0002\n\"A1/!\"\u0002\u0002\u0003\u0007\u0011\u000e\u0003\u0005v\u0003;\n\t\u0011\"\u0011w\u0011%q\u0018QLA\u0001\n\u0003\ty\t\u0006\u0003\u0002\u0002\u0005E\u0005\u0002C:\u0002\u000e\u0006\u0005\t\u0019A8\t\u0015\u0005-\u0011QLA\u0001\n\u0003\ni\u0001\u0003\u0006\u0002\u0012\u0005u\u0013\u0011!C!\u0003'A!\"a\u0006\u0002^\u0005\u0005I\u0011IAM)\u0011\t\t!a'\t\u0011M\f9*!AA\u0002=<\u0011\"a(\r\u0003\u0003E\t!!)\u0002\u0017M\u0013h/U;fgRLwN\u001c\t\u0004O\u0005\rf!CA0\u0019\u0005\u0005\t\u0012AAS'\u0015\t\u0019+a*,!!\tI+a, i\u0005=TBAAV\u0015\r\ti+E\u0001\beVtG/[7f\u0013\u0011\t\t,a+\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004\u0017\u0003G#\t!!.\u0015\u0005\u0005\u0005\u0006BCA\t\u0003G\u000b\t\u0011\"\u0012\u0002\u0014!Q\u00111XAR\u0003\u0003%\t)!0\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005=\u0014qXAa\u0011\u0019i\u0012\u0011\u0018a\u0001?!1!'!/A\u0002QB!\"!2\u0002$\u0006\u0005I\u0011QAd\u0003\u001d)h.\u00199qYf$B!!3\u0002VB)\u0001#a3\u0002P&\u0019\u0011QZ\t\u0003\r=\u0003H/[8o!\u0015\u0001\u0012\u0011[\u00105\u0013\r\t\u0019.\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0015\u0005]\u00171YA\u0001\u0002\u0004\ty'A\u0002yIAB!\"a7\u0002$\u0006\u0005I\u0011BAo\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\u0007c\u00011\u0002b&\u0019\u00111]1\u0003\r=\u0013'.Z2u\u000f%\t9\u000fDA\u0001\u0012\u0003\tI/A\u0005Rk\u0016\u001cH/[8oiA\u0019q%a;\u0007\u0011\u0011b\u0011\u0011!E\u0001\u0003[\u001cR!a;\u0002p.\u0002r!!+\u00020~!4\tC\u0004\u0017\u0003W$\t!a=\u0015\u0005\u0005%\bBCA\t\u0003W\f\t\u0011\"\u0012\u0002\u0014!Q\u00111XAv\u0003\u0003%\t)!?\u0015\u000b\r\u000bY0!@\t\ru\t9\u00101\u0001 \u0011\u0019\u0011\u0014q\u001fa\u0001i!Q\u0011QYAv\u0003\u0003%\tI!\u0001\u0015\t\u0005%'1\u0001\u0005\n\u0003/\fy0!AA\u0002\rC!\"a7\u0002l\u0006\u0005I\u0011BAo\u000f%\u0011I\u0001DA\u0001\u0012\u0003\u0011Y!A\u0005Rk\u0016\u001cH/[8omA\u0019qE!\u0004\u0007\u0013\u0005}A\"!A\t\u0002\t=1#\u0002B\u0007\u0005#Y\u0003\u0003CAU\u0003_{B'a\f\t\u000fY\u0011i\u0001\"\u0001\u0003\u0016Q\u0011!1\u0002\u0005\u000b\u0003#\u0011i!!A\u0005F\u0005M\u0001BCA^\u0005\u001b\t\t\u0011\"!\u0003\u001cQ1\u0011q\u0006B\u000f\u0005?Aa!\bB\r\u0001\u0004y\u0002B\u0002\u001a\u0003\u001a\u0001\u0007A\u0007\u0003\u0006\u0002F\n5\u0011\u0011!CA\u0005G!B!!3\u0003&!Q\u0011q\u001bB\u0011\u0003\u0003\u0005\r!a\f\t\u0015\u0005m'QBA\u0001\n\u0013\tiN\u0002\u0004\u0003,1\u0011%Q\u0006\u0002\u0007\u0003:\u001cx/\u001a:\u0014\u000f\t%rBa\f)WA!!\u0011\u0007B\u001c\u001b\t\u0011\u0019DC\u0002\u00036!\tQ!Y2u_JLAA!\u000f\u00034\t\tcj\\*fe&\fG.\u001b>bi&|gNV3sS\u001aL7-\u0019;j_:tU-\u001a3fI\"IQD!\u000b\u0003\u0016\u0004%\tA\b\u0005\na\t%\"\u0011#Q\u0001\n}A1B!\u0011\u0003*\tU\r\u0011\"\u0001\u0003D\u0005\u0019!O]:\u0016\u0005\t\u0015\u0003C\u0002B$\u0005\u001b\u0012\t&\u0004\u0002\u0003J)\u0019!1J=\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002B(\u0005\u0013\u00121aU3r!\u0011\u0011\u0019F!\u0016\u000e\u0003\u0011I1Aa\u0016\u0005\u00059\u0011Vm]8ve\u000e,'+Z2pe\u0012D1Ba\u0017\u0003*\tE\t\u0015!\u0003\u0003F\u0005!!O]:!\u0011\u001d1\"\u0011\u0006C\u0001\u0005?\"bA!\u0019\u0003d\t\u0015\u0004cA\u0014\u0003*!1QD!\u0018A\u0002}A\u0001B!\u0011\u0003^\u0001\u0007!Q\t\u0005\n\u000f\n%\u0012\u0011!C\u0001\u0005S\"bA!\u0019\u0003l\t5\u0004\u0002C\u000f\u0003hA\u0005\t\u0019A\u0010\t\u0015\t\u0005#q\rI\u0001\u0002\u0004\u0011)\u0005\u0003\u0005M\u0005S\t\n\u0011\"\u0001N\u0011%I&\u0011FI\u0001\n\u0003\u0011\u0019(\u0006\u0002\u0003v)\u001a!QI(\t\u0011u\u0013I#!A\u0005ByC\u0001b\u001aB\u0015\u0003\u0003%\t\u0001\u001b\u0005\n[\n%\u0012\u0011!C\u0001\u0005{\"2a\u001cB@\u0011!\u0019(1PA\u0001\u0002\u0004I\u0007\u0002C;\u0003*\u0005\u0005I\u0011\t<\t\u0013y\u0014I#!A\u0005\u0002\t\u0015E\u0003BA\u0001\u0005\u000fC\u0001b\u001dBB\u0003\u0003\u0005\ra\u001c\u0005\u000b\u0003\u0017\u0011I#!A\u0005B\u00055\u0001BCA\t\u0005S\t\t\u0011\"\u0011\u0002\u0014!Q\u0011q\u0003B\u0015\u0003\u0003%\tEa$\u0015\t\u0005\u0005!\u0011\u0013\u0005\tg\n5\u0015\u0011!a\u0001_\u001eI!Q\u0013\u0007\u0002\u0002#\u0005!qS\u0001\u0007\u0003:\u001cx/\u001a:\u0011\u0007\u001d\u0012IJB\u0005\u0003,1\t\t\u0011#\u0001\u0003\u001cN)!\u0011\u0014BOWAI\u0011\u0011VAX?\t\u0015#\u0011\r\u0005\b-\teE\u0011\u0001BQ)\t\u00119\n\u0003\u0006\u0002\u0012\te\u0015\u0011!C#\u0003'A!\"a/\u0003\u001a\u0006\u0005I\u0011\u0011BT)\u0019\u0011\tG!+\u0003,\"1QD!*A\u0002}A\u0001B!\u0011\u0003&\u0002\u0007!Q\t\u0005\u000b\u0003\u000b\u0014I*!A\u0005\u0002\n=F\u0003\u0002BY\u0005k\u0003R\u0001EAf\u0005g\u0003b\u0001EAi?\t\u0015\u0003BCAl\u0005[\u000b\t\u00111\u0001\u0003b!Q\u00111\u001cBM\u0003\u0003%I!!8\u0007\r\tmFB\u0011B_\u0005-!%o\u001c9SKF,Xm\u001d;\u0014\u000b\tev\u0002K\u0016\t\u0013u\u0011IL!f\u0001\n\u0003q\u0002\"\u0003\u0019\u0003:\nE\t\u0015!\u0003 \u0011\u001d1\"\u0011\u0018C\u0001\u0005\u000b$BAa2\u0003JB\u0019qE!/\t\ru\u0011\u0019\r1\u0001 \u0011%9%\u0011XA\u0001\n\u0003\u0011i\r\u0006\u0003\u0003H\n=\u0007\u0002C\u000f\u0003LB\u0005\t\u0019A\u0010\t\u00111\u0013I,%A\u0005\u00025C\u0001\"\u0018B]\u0003\u0003%\tE\u0018\u0005\tO\ne\u0016\u0011!C\u0001Q\"IQN!/\u0002\u0002\u0013\u0005!\u0011\u001c\u000b\u0004_\nm\u0007\u0002C:\u0003X\u0006\u0005\t\u0019A5\t\u0011U\u0014I,!A\u0005BYD\u0011B B]\u0003\u0003%\tA!9\u0015\t\u0005\u0005!1\u001d\u0005\tg\n}\u0017\u0011!a\u0001_\"Q\u00111\u0002B]\u0003\u0003%\t%!\u0004\t\u0015\u0005E!\u0011XA\u0001\n\u0003\n\u0019\u0002\u0003\u0006\u0002\u0018\te\u0016\u0011!C!\u0005W$B!!\u0001\u0003n\"A1O!;\u0002\u0002\u0003\u0007qnB\u0005\u0003r2\t\t\u0011#\u0001\u0003t\u0006YAI]8q%\u0016\fX/Z:u!\r9#Q\u001f\u0004\n\u0005wc\u0011\u0011!E\u0001\u0005o\u001cRA!>\u0003z.\u0002r!!+\u0003|~\u00119-\u0003\u0003\u0003~\u0006-&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9aC!>\u0005\u0002\r\u0005AC\u0001Bz\u0011)\t\tB!>\u0002\u0002\u0013\u0015\u00131\u0003\u0005\u000b\u0003w\u0013)0!A\u0005\u0002\u000e\u001dA\u0003\u0002Bd\u0007\u0013Aa!HB\u0003\u0001\u0004y\u0002BCAc\u0005k\f\t\u0011\"!\u0004\u000eQ!1qBB\t!\u0011\u0001\u00121Z\u0010\t\u0015\u0005]71BA\u0001\u0002\u0004\u00119\r\u0003\u0006\u0002\\\nU\u0018\u0011!C\u0005\u0003;D3\u0001DB\f!\u0011\u0019Ib!\b\u000e\u0005\rm!BA+\t\u0013\u0011\u0019yba\u0007\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u0004\u0001\r]aAB\u0007\u0003\u0001!\u0019)cE\u0005\u0004$=\u00199c!\f\u00044A!!\u0011GB\u0015\u0013\u0011\u0019YCa\r\u0003\u000b\u0005\u001bGo\u001c:\u0011\t\tE2qF\u0005\u0005\u0007c\u0011\u0019D\u0001\u0007BGR|'\u000fT8hO&tw\r\u0005\u0003\u00032\rU\u0012\u0002BB\u001c\u0005g\u0011Qa\u0015;bg\"D1ba\u000f\u0004$\t\u0005\t\u0015!\u0003\u0004>\u0005\u0011an\u001d\t\u0005\u0007\u007f\u0019)%\u0004\u0002\u0004B)\u001911I2\u0002\u00079,G/\u0003\u0003\u0004H\r\u0005#!E%oKR\u001cvnY6fi\u0006#GM]3tg\"9aca\t\u0005\u0002\r-C\u0003BB'\u0007\u001f\u00022aCB\u0012\u0011!\u0019Yd!\u0013A\u0002\ru\u0002BCB*\u0007G\u0001\r\u0011\"\u0001\u0004V\u0005\u0001\u0012N\u001c4mS\u001eDGOU3rk\u0016\u001cHo]\u000b\u0003\u0007/\u0002b!NB-?\ru\u0013bAB.}\t\u0019Q*\u00199\u0011\t\tE2qL\u0005\u0005\u0007C\u0012\u0019D\u0001\u0005BGR|'OU3g\u0011)\u0019)ga\tA\u0002\u0013\u00051qM\u0001\u0015S:4G.[4iiJ+\u0017/^3tiN|F%Z9\u0015\t\r%4q\u000e\t\u0004!\r-\u0014bAB7#\t!QK\\5u\u0011%\u001981MA\u0001\u0002\u0004\u00199\u0006C\u0005\u0004t\r\r\u0002\u0015)\u0003\u0004X\u0005\t\u0012N\u001c4mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\t\u0011\r]41\u0005C\u0001\u0007s\nqA]3dK&4X-\u0006\u0002\u0004|A!1QPB@\u001b\t\u0019\u0019#\u0003\u0003\u0004\u0002\u000e%\"a\u0002*fG\u0016Lg/\u001a\u0005\t\u0007\u000b\u001b\u0019\u0003\"\u0003\u0004\b\u00069Q.Z:tC\u001e,G\u0003CBE\u0007\u001f\u001b\tja%\u0011\u0007-\u0019Y)C\u0002\u0004\u000e\n\u0011q!T3tg\u0006<W\r\u0003\u00043\u0007\u0007\u0003\r\u0001\u000e\u0005\u0007;\r\r\u0005\u0019A\u0010\t\u0011\rU51\u0011a\u0001\u0007/\u000b!B]3d_J$G+\u001f9f!\u0011\u0011\u0019f!'\n\u0007\rmEA\u0001\u0006SK\u000e|'\u000f\u001a+za\u0016D\u0001ba(\u0004$\u0011\u00051\u0011U\u0001\u0006e\u0016\fG-\u001f\u000b\u0005\u0007w\u001a\u0019\u000b\u0003\u0005\u0004&\u000eu\u0005\u0019AB/\u0003\u0019\u0019xnY6fi\"\"11EB\f\u0001")
public class DnsClient
implements ActorLogging,
Stash {
    public final InetSocketAddress akka$io$dns$internal$DnsClient$$ns;
    private Map<Object, ActorRef> inflightRequests;
    private Vector<Envelope> akka$actor$StashSupport$$theStash;
    private final int akka$actor$StashSupport$$capacity;
    private final DequeBasedMessageQueueSemantics mailbox;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) {
        UnrestrictedStash.preRestart$(this, reason, message);
    }

    @Override
    public void postStop() {
        UnrestrictedStash.postStop$(this);
    }

    @Override
    public void stash() {
        StashSupport.stash$(this);
    }

    @Override
    public void prepend(scala.collection.immutable.Seq<Envelope> others) {
        StashSupport.prepend$(this, others);
    }

    @Override
    public void unstash() {
        StashSupport.unstash$(this);
    }

    @Override
    public void unstashAll() {
        StashSupport.unstashAll$(this);
    }

    @Override
    public void unstashAll(Function1<Object, Object> filterPredicate) {
        StashSupport.unstashAll$(this, filterPredicate);
    }

    @Override
    public Vector<Envelope> clearStash() {
        return StashSupport.clearStash$(this);
    }

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public Vector<Envelope> akka$actor$StashSupport$$theStash() {
        return this.akka$actor$StashSupport$$theStash;
    }

    @Override
    public void akka$actor$StashSupport$$theStash_$eq(Vector<Envelope> x$1) {
        this.akka$actor$StashSupport$$theStash = x$1;
    }

    @Override
    public int akka$actor$StashSupport$$capacity() {
        return this.akka$actor$StashSupport$$capacity;
    }

    @Override
    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    @Override
    public final void akka$actor$StashSupport$_setter_$akka$actor$StashSupport$$capacity_$eq(int x$1) {
        this.akka$actor$StashSupport$$capacity = x$1;
    }

    @Override
    public void akka$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$1) {
        this.mailbox = x$1;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Map<Object, ActorRef> inflightRequests() {
        return this.inflightRequests;
    }

    public void inflightRequests_$eq(Map<Object, ActorRef> x$1) {
        this.inflightRequests = x$1;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DnsClient $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Udp.Bound) {
                    Udp.Bound bound2 = (Udp.Bound)A1;
                    InetSocketAddress local = bound2.localAddress();
                    this.$outer.log().debug("Bound to UDP address [{}]", local);
                    this.$outer.context().become(this.$outer.ready(this.$outer.sender()));
                    this.$outer.unstashAll();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Question4) {
                    this.$outer.stash();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Question6) {
                    this.$outer.stash();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof SrvQuestion) {
                    this.$outer.stash();
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Udp.Bound ? true : (object instanceof Question4 ? true : (object instanceof Question6 ? true : object instanceof SrvQuestion));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Message akka$io$dns$internal$DnsClient$$message(String name, short id, RecordType recordType) {
        return new Message(id, MessageFlags$.MODULE$.apply(MessageFlags$.MODULE$.apply$default$1(), MessageFlags$.MODULE$.apply$default$2(), MessageFlags$.MODULE$.apply$default$3(), MessageFlags$.MODULE$.apply$default$4(), MessageFlags$.MODULE$.apply$default$5(), MessageFlags$.MODULE$.apply$default$6(), MessageFlags$.MODULE$.apply$default$7()), (scala.collection.immutable.Seq<Question>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Question[]{new Question(name, recordType, RecordClass$.MODULE$.IN())}))), Message$.MODULE$.apply$default$4(), Message$.MODULE$.apply$default$5(), Message$.MODULE$.apply$default$6());
    }

    public PartialFunction<Object, BoxedUnit> ready(ActorRef socket) {
        return new scala.Serializable(this, socket){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DnsClient $outer;
            private final ActorRef socket$1;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof DropRequest) {
                    DropRequest dropRequest = (DropRequest)A1;
                    short id = dropRequest.id();
                    this.$outer.log().debug("Dropping request [{}]", BoxesRunTime.boxToShort((short)id));
                    this.$outer.inflightRequests_$eq((Map<Object, ActorRef>)((Map)this.$outer.inflightRequests().$minus((Object)BoxesRunTime.boxToShort((short)id))));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Question4) {
                    Question4 question4 = (Question4)A1;
                    short id = question4.id();
                    String name = question4.name();
                    this.$outer.log().debug("Resolving [{}] (A)", name);
                    this.$outer.inflightRequests_$eq((Map<Object, ActorRef>)this.$outer.inflightRequests().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)id)), (Object)this.$outer.sender())));
                    Message msg = this.$outer.akka$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.A());
                    this.$outer.log().debug("Message [{}] to [{}]: [{}]", BoxesRunTime.boxToShort((short)id), this.$outer.akka$io$dns$internal$DnsClient$$ns, msg);
                    package$.MODULE$.actorRef2Scala(this.socket$1).$bang(Udp$Send$.MODULE$.apply(msg.write(), this.$outer.akka$io$dns$internal$DnsClient$$ns), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Question6) {
                    Question6 question6 = (Question6)A1;
                    short id = question6.id();
                    String name = question6.name();
                    this.$outer.log().debug("Resolving [{}] (AAAA)", name);
                    this.$outer.inflightRequests_$eq((Map<Object, ActorRef>)this.$outer.inflightRequests().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)id)), (Object)this.$outer.sender())));
                    Message msg = this.$outer.akka$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.AAAA());
                    this.$outer.log().debug("Message to [{}]: [{}]", this.$outer.akka$io$dns$internal$DnsClient$$ns, msg);
                    package$.MODULE$.actorRef2Scala(this.socket$1).$bang(Udp$Send$.MODULE$.apply(msg.write(), this.$outer.akka$io$dns$internal$DnsClient$$ns), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof SrvQuestion) {
                    SrvQuestion srvQuestion = (SrvQuestion)A1;
                    short id = srvQuestion.id();
                    String name = srvQuestion.name();
                    this.$outer.log().debug("Resolving [{}] (SRV)", name);
                    this.$outer.inflightRequests_$eq((Map<Object, ActorRef>)this.$outer.inflightRequests().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)id)), (Object)this.$outer.sender())));
                    Message msg = this.$outer.akka$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.SRV());
                    this.$outer.log().debug("Message to {}: msg", this.$outer.akka$io$dns$internal$DnsClient$$ns, msg);
                    package$.MODULE$.actorRef2Scala(this.socket$1).$bang(Udp$Send$.MODULE$.apply(msg.write(), this.$outer.akka$io$dns$internal$DnsClient$$ns), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Udp.CommandFailed) {
                    Udp.CommandFailed commandFailed = (Udp.CommandFailed)A1;
                    Udp.Command cmd = commandFailed.cmd();
                    this.$outer.log().debug("Command failed [{}]", cmd);
                    Udp.Command command = cmd;
                    if (command instanceof Udp.Send) {
                        Udp.Send send = (Udp.Send)command;
                        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            Message msg = Message$.MODULE$.parse(send.payload());
                            $this.$outer.inflightRequests().get((Object)BoxesRunTime.boxToShort((short)msg.id())).foreach((Function1 & Serializable & scala.Serializable)s -> {
                                $anonfun$ready$1.$anonfun$applyOrElse$2(this, msg, s);
                                return BoxedUnit.UNIT;
                            });
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.log().warning("Dns client failed to send {}", cmd);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Udp.Received) {
                    Udp.Received received = (Udp.Received)A1;
                    ByteString data = received.data();
                    InetSocketAddress remote = received.sender();
                    this.$outer.log().debug("Received message from [{}]: [{}]", remote, data);
                    Message msg = Message$.MODULE$.parse(data);
                    this.$outer.log().debug(new StringBuilder(9).append("Decoded: ").append(msg).toString());
                    Enumeration.Value value = MessageFlags$.MODULE$.responseCode$extension(msg.flags());
                    Enumeration.Value value2 = ResponseCode$.MODULE$.SUCCESS();
                    scala.collection.immutable.Seq recs = !(value != null ? !value.equals(value2) : value2 != null) ? msg.answerRecs() : (scala.collection.immutable.Seq)Seq$.MODULE$.empty();
                    Answer response = new Answer(msg.id(), (scala.collection.immutable.Seq<ResourceRecord>)recs);
                    Option option = this.$outer.inflightRequests().get((Object)BoxesRunTime.boxToShort((short)response.id()));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ActorRef reply = (ActorRef)some.value();
                        package$.MODULE$.actorRef2Scala(reply).$bang(response, this.$outer.self());
                        this.$outer.inflightRequests_$eq((Map<Object, ActorRef>)((Map)this.$outer.inflightRequests().$minus((Object)BoxesRunTime.boxToShort((short)response.id()))));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        this.$outer.log().debug("Client for id {} not found. Discarding response.", BoxesRunTime.boxToShort((short)response.id()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object = BoxedUnit.UNIT;
                } else if (Udp$Unbind$.MODULE$.equals(A1)) {
                    package$.MODULE$.actorRef2Scala(this.socket$1).$bang(Udp$Unbind$.MODULE$, this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (Udp$Unbound$.MODULE$.equals(A1)) {
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = object instanceof DropRequest ? true : (object instanceof Question4 ? true : (object instanceof Question6 ? true : (object instanceof SrvQuestion ? true : (object instanceof Udp.CommandFailed ? true : (object instanceof Udp.Received ? true : (Udp$Unbind$.MODULE$.equals(object) ? true : Udp$Unbound$.MODULE$.equals(object)))))));
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$ready$1 $this, Message msg$1, ActorRef s) {
                package$.MODULE$.actorRef2Scala(s).$bang(new Status.Failure(new RuntimeException("Send failed to nameserver")), $this.$outer.self());
                $this.$outer.inflightRequests_$eq((Map<Object, ActorRef>)((Map)$this.$outer.inflightRequests().$minus((Object)BoxesRunTime.boxToShort((short)msg$1.id()))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.socket$1 = socket$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.io.dns.internal.DnsClient$$anonfun$ready$1 akka.io.Udp$Send ), $anonfun$applyOrElse$2$adapted(akka.io.dns.internal.DnsClient$$anonfun$ready$1 akka.io.dns.internal.Message akka.actor.ActorRef )}, serializedLambda);
            }
        };
    }

    public DnsClient(InetSocketAddress ns) {
        this.akka$io$dns$internal$DnsClient$$ns = ns;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        StashSupport.$init$(this);
        UnrestrictedStash.$init$(this);
        package$.MODULE$.actorRef2Scala(IO$.MODULE$.apply(Udp$.MODULE$, this.context().system())).$bang(new Udp.Bind(this.self(), new InetSocketAddress(InetAddress.getByAddress((byte[])Array$.MODULE$.ofDim(4, ClassTag$.MODULE$.Byte())), 0), Udp$Bind$.MODULE$.apply$default$3()), this.self());
        this.inflightRequests = Predef$.MODULE$.Map().empty();
    }

    public static final class Answer
    implements NoSerializationVerificationNeeded,
    Product,
    scala.Serializable {
        private final short id;
        private final scala.collection.immutable.Seq<ResourceRecord> rrs;

        public short id() {
            return this.id;
        }

        public scala.collection.immutable.Seq<ResourceRecord> rrs() {
            return this.rrs;
        }

        public Answer copy(short id, scala.collection.immutable.Seq<ResourceRecord> rrs) {
            return new Answer(id, rrs);
        }

        public short copy$default$1() {
            return this.id();
        }

        public scala.collection.immutable.Seq<ResourceRecord> copy$default$2() {
            return this.rrs();
        }

        public String productPrefix() {
            return "Answer";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToShort((short)this.id());
                    break;
                }
                case 1: {
                    object = this.rrs();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Answer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rrs()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Answer)) return false;
            boolean bl = true;
            if (!bl) return false;
            Answer answer = (Answer)x$1;
            if (this.id() != answer.id()) return false;
            scala.collection.immutable.Seq<ResourceRecord> seq = this.rrs();
            scala.collection.immutable.Seq<ResourceRecord> seq2 = answer.rrs();
            if (seq != null) {
                if (!seq.equals(seq2)) return false;
                return true;
            }
            if (seq2 == null) return true;
            return false;
        }

        public Answer(short id, scala.collection.immutable.Seq<ResourceRecord> rrs) {
            this.id = id;
            this.rrs = rrs;
            Product.$init$((Product)this);
        }
    }

    public static interface DnsQuestion {
        public short id();
    }

    public static final class DropRequest
    implements Product,
    scala.Serializable {
        private final short id;

        public short id() {
            return this.id;
        }

        public DropRequest copy(short id) {
            return new DropRequest(id);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String productPrefix() {
            return "DropRequest";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return BoxesRunTime.boxToShort((short)this.id());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DropRequest;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.id());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DropRequest)) return false;
            boolean bl = true;
            if (!bl) return false;
            DropRequest dropRequest = (DropRequest)x$1;
            if (this.id() != dropRequest.id()) return false;
            return true;
        }

        public DropRequest(short id) {
            this.id = id;
            Product.$init$((Product)this);
        }
    }

    public static final class Question4
    implements DnsQuestion,
    Product,
    scala.Serializable {
        private final short id;
        private final String name;

        @Override
        public short id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Question4 copy(short id, String name) {
            return new Question4(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String productPrefix() {
            return "Question4";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToShort((short)this.id());
                    break;
                }
                case 1: {
                    object = this.name();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Question4;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Question4)) return false;
            boolean bl = true;
            if (!bl) return false;
            Question4 question4 = (Question4)x$1;
            if (this.id() != question4.id()) return false;
            String string = this.name();
            String string2 = question4.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public Question4(short id, String name) {
            this.id = id;
            this.name = name;
            Product.$init$((Product)this);
        }
    }

    public static final class Question6
    implements DnsQuestion,
    Product,
    scala.Serializable {
        private final short id;
        private final String name;

        @Override
        public short id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Question6 copy(short id, String name) {
            return new Question6(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String productPrefix() {
            return "Question6";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToShort((short)this.id());
                    break;
                }
                case 1: {
                    object = this.name();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Question6;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Question6)) return false;
            boolean bl = true;
            if (!bl) return false;
            Question6 question6 = (Question6)x$1;
            if (this.id() != question6.id()) return false;
            String string = this.name();
            String string2 = question6.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public Question6(short id, String name) {
            this.id = id;
            this.name = name;
            Product.$init$((Product)this);
        }
    }

    public static final class SrvQuestion
    implements DnsQuestion,
    Product,
    scala.Serializable {
        private final short id;
        private final String name;

        @Override
        public short id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public SrvQuestion copy(short id, String name) {
            return new SrvQuestion(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String productPrefix() {
            return "SrvQuestion";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToShort((short)this.id());
                    break;
                }
                case 1: {
                    object = this.name();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SrvQuestion;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SrvQuestion)) return false;
            boolean bl = true;
            if (!bl) return false;
            SrvQuestion srvQuestion = (SrvQuestion)x$1;
            if (this.id() != srvQuestion.id()) return false;
            String string = this.name();
            String string2 = srvQuestion.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public SrvQuestion(short id, String name) {
            this.id = id;
            this.name = name;
            Product.$init$((Product)this);
        }
    }
}

