/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Deploy$;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.actor.TimerScheduler;
import akka.actor.TimerSchedulerImpl;
import akka.actor.Timers;
import akka.annotation.InternalApi;
import akka.dispatch.RequiresMessageQueue;
import akka.dispatch.UnboundedMessageQueueSemantics;
import akka.event.LoggingAdapter;
import akka.io.Dns;
import akka.io.DnsExt;
import akka.io.PeriodicCacheCleanup;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolve$;
import akka.io.dns.DnsSettings;
import akka.io.dns.internal.AsyncDnsManager$;
import akka.io.dns.internal.AsyncDnsManager$CacheCleanup$;
import akka.io.dns.internal.DnsClient;
import akka.routing.FromConfig$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005]vAB\u0001\u0003\u0011\u00031!\"A\bBgft7\r\u00128t\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!\u0001\u0005j]R,'O\\1m\u0015\t)a!A\u0002e]NT!a\u0002\u0005\u0002\u0005%|'\"A\u0005\u0002\t\u0005\\7.\u0019\t\u0003\u00171i\u0011A\u0001\u0004\u0007\u001b\tA\tA\u0002\b\u0003\u001f\u0005\u001b\u0018P\\2E]Nl\u0015M\\1hKJ\u001c\"\u0001D\b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g\u0011\u00151B\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0006\b\u000bia\u0001\u0012R\u000e\u0002\u0019\r\u000b7\r[3DY\u0016\fg.\u001e9\u0011\u0005qiR\"\u0001\u0007\u0007\u000bya\u0001\u0012R\u0010\u0003\u0019\r\u000b7\r[3DY\u0016\fg.\u001e9\u0014\tuy\u0001e\t\t\u0003!\u0005J!AI\t\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\u0003J\u0005\u0003KE\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAF\u000f\u0005\u0002\u001d\"\u0012a\u0007\u0005\bSu\t\t\u0011\"\u0011+\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t1\u0006\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A.\u00198h\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\rM#(/\u001b8h\u0011\u001d!T$!A\u0005\u0002U\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\u000e\t\u0003!]J!\u0001O\t\u0003\u0007%sG\u000fC\u0004;;\u0005\u0005I\u0011A\u001e\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0011Ah\u0010\t\u0003!uJ!AP\t\u0003\u0007\u0005s\u0017\u0010C\u0004As\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013\u0007C\u0004C;\u0005\u0005I\u0011I\"\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\u0012\u0001\u0012\t\u0004\u000b\"cT\"\u0001$\u000b\u0005\u001d\u000b\u0012AC2pY2,7\r^5p]&\u0011\u0011J\u0012\u0002\t\u0013R,'/\u0019;pe\"91*HA\u0001\n\u0003a\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\u00055\u0003\u0006C\u0001\tO\u0013\ty\u0015CA\u0004C_>dW-\u00198\t\u000f\u0001S\u0015\u0011!a\u0001y!9!+HA\u0001\n\u0003\u001a\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003YBq!V\u000f\u0002\u0002\u0013\u0005c+\u0001\u0005u_N#(/\u001b8h)\u0005Y\u0003b\u0002-\u001e\u0003\u0003%I!W\u0001\fe\u0016\fGMU3t_24X\rF\u0001[!\ta3,\u0003\u0002][\t1qJ\u00196fGRD#\u0001\u00040\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005D\u0011AC1o]>$\u0018\r^5p]&\u00111\r\u0019\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e\u000b\u0002\u0001=\u001a)QB\u0001\u0002\u0007MN1QmD4nmf\u0004\"\u0001[6\u000e\u0003%T!A\u001b\u0005\u0002\u000b\u0005\u001cGo\u001c:\n\u00051L'!B!di>\u0014\bc\u00018rg6\tqN\u0003\u0002q\u0011\u0005AA-[:qCR\u001c\u0007.\u0003\u0002s_\n!\"+Z9vSJ,7/T3tg\u0006<W-U;fk\u0016\u0004\"A\u001c;\n\u0005U|'AH+oE>,h\u000eZ3e\u001b\u0016\u001c8/Y4f#V,W/Z*f[\u0006tG/[2t!\tAw/\u0003\u0002yS\na\u0011i\u0019;pe2{wmZ5oOB\u0011\u0001N_\u0005\u0003w&\u0014a\u0001V5nKJ\u001c\b\u0002C?f\u0005\u000b\u0007I\u0011\u0001@\u0002\u0007\u0015DH/F\u0001\u0000!\u0011\t\t!a\u0001\u000e\u0003\u0019I1!!\u0002\u0007\u0005\u0019!en]#yi\"I\u0011\u0011B3\u0003\u0002\u0003\u0006Ia`\u0001\u0005Kb$\b\u0005\u0003\u0004\u0017K\u0012\u0005\u0011Q\u0002\u000b\u0005\u0003\u001f\t\t\u0002\u0005\u0002\fK\"1Q0a\u0003A\u0002}D\u0011\"!\u0006f\u0005\u0004%\u0019!a\u0006\u0002\u0005\u0015\u001cWCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010#\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\r\u0012Q\u0004\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\b\u0002CA\u0014K\u0002\u0006I!!\u0007\u0002\u0007\u0015\u001c\u0007\u0005\u0003\u0005\u0002,\u0015\u0004\r\u0011\"\u00036\u0003uyG\u000e\u001a)s_R|7m\u001c7XCJt\u0017N\\4M_\u001e<W\r\u001a+j[\u0016\u001c\b\"CA\u0018K\u0002\u0007I\u0011BA\u0019\u0003\u0005zG\u000e\u001a)s_R|7m\u001c7XCJt\u0017N\\4M_\u001e<W\r\u001a+j[\u0016\u001cx\fJ3r)\u0011\t\u0019$!\u000f\u0011\u0007A\t)$C\u0002\u00028E\u0011A!\u00168ji\"A\u0001)!\f\u0002\u0002\u0003\u0007a\u0007C\u0004\u0002>\u0015\u0004\u000b\u0015\u0002\u001c\u0002==dG\r\u0015:pi>\u001cw\u000e\\,be:Lgn\u001a'pO\u001e,G\rV5nKN\u0004\u0003\"CA!K\n\u0007I\u0011AA\"\u0003!\u0019X\r\u001e;j]\u001e\u001cXCAA#!\u0011\t9%!\u0013\u000e\u0003\u0011I1!a\u0013\u0005\u0005-!en]*fiRLgnZ:\t\u0011\u0005=S\r)A\u0005\u0003\u000b\n\u0011b]3ui&twm\u001d\u0011\t\u0013\u0005MSM1A\u0005\n\u0005U\u0013\u0001\u0003:fg>dg/\u001a:\u0016\u0005\u0005]\u0003c\u00015\u0002Z%\u0019\u00111L5\u0003\u0011\u0005\u001bGo\u001c:SK\u001aD\u0001\"a\u0018fA\u0003%\u0011qK\u0001\ne\u0016\u001cx\u000e\u001c<fe\u0002B\u0011\"a\u0019f\u0005\u0004%I!!\u001a\u0002\u0019\r\f7\r[3DY\u0016\fg.\u001e9\u0016\u0005\u0005\u001d\u0004#\u0002\t\u0002j\u00055\u0014bAA6#\t1q\n\u001d;j_:\u0014b!a\u001c\u0002t\u0005edABA9\u0001\u0001\tiG\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003\u0002\u0002\u0005U\u0014bAA<\r\t\u0019AI\\:\u0011\t\u0005\u0005\u00111P\u0005\u0004\u0003{2!\u0001\u0006)fe&|G-[2DC\u000eDWm\u00117fC:,\b\u000f\u0003\u0005\u0002\u0002\u0016\u0004\u000b\u0011BA4\u00035\u0019\u0017m\u00195f\u00072,\u0017M\\;qA!9\u0011QQ3\u0005B\u0005\u001d\u0015\u0001\u00039sKN#\u0018M\u001d;\u0015\u0005\u0005M\u0002bBAFK\u0012\u0005\u0013QR\u0001\be\u0016\u001cW-\u001b<f+\t\ty\t\u0005\u0003\u0002\u0012\u0006MU\"A3\n\u0007\u0005U5NA\u0004SK\u000e,\u0017N^3\t\u000f\u0005eU\r\"\u0003\u0002\u001c\u00069r/\u0019:o\u0003\n|W\u000f^(mIB\u0013x\u000e^8d_2,6/\u001a\u000b\u0005\u0003g\ti\n\u0003\u0005\u0002 \u0006]\u0005\u0019AAQ\u0003\u0011q\u0017-\\3\u0011\t\u0005\r\u0016\u0011\u0017\b\u0005\u0003K\u000bi\u000bE\u0002\u0002(Fi!!!+\u000b\u0007\u0005-v#\u0001\u0004=e>|GOP\u0005\u0004\u0003_\u000b\u0012A\u0002)sK\u0012,g-C\u00023\u0003gS1!a,\u0012Q\t)g\f")
public final class AsyncDnsManager
implements RequiresMessageQueue<UnboundedMessageQueueSemantics>,
ActorLogging,
Timers {
    private final DnsExt ext;
    private final ExecutionContextExecutor ec;
    private int oldProtocolWarningLoggedTimes;
    private final DnsSettings settings;
    private final ActorRef akka$io$dns$internal$AsyncDnsManager$$resolver;
    private final Option<Dns> akka$io$dns$internal$AsyncDnsManager$$cacheCleanup;
    private final TimerSchedulerImpl akka$actor$Timers$$_timers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public /* synthetic */ void akka$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    public /* synthetic */ void akka$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    public /* synthetic */ void akka$actor$Timers$$super$aroundReceive(PartialFunction receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    public final TimerScheduler timers() {
        return Timers.timers$(this);
    }

    @Override
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Timers.aroundPreRestart$(this, reason, message);
    }

    @Override
    public void aroundPostStop() {
        Timers.aroundPostStop$(this);
    }

    @Override
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Timers.aroundReceive$(this, receive2, msg);
    }

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public TimerSchedulerImpl akka$actor$Timers$$_timers() {
        return this.akka$actor$Timers$$_timers;
    }

    @Override
    public final void akka$actor$Timers$_setter_$akka$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$1) {
        this.akka$actor$Timers$$_timers = x$1;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public DnsExt ext() {
        return this.ext;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    private int oldProtocolWarningLoggedTimes() {
        return this.oldProtocolWarningLoggedTimes;
    }

    private void oldProtocolWarningLoggedTimes_$eq(int x$1) {
        this.oldProtocolWarningLoggedTimes = x$1;
    }

    public DnsSettings settings() {
        return this.settings;
    }

    public ActorRef akka$io$dns$internal$AsyncDnsManager$$resolver() {
        return this.akka$io$dns$internal$AsyncDnsManager$$resolver;
    }

    public Option<Dns> akka$io$dns$internal$AsyncDnsManager$$cacheCleanup() {
        return this.akka$io$dns$internal$AsyncDnsManager$$cacheCleanup;
    }

    @Override
    public void preStart() {
        this.akka$io$dns$internal$AsyncDnsManager$$cacheCleanup().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            AsyncDnsManager.$anonfun$preStart$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsManager $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve2 = (DnsProtocol.Resolve)A1;
                    this.$outer.log().debug("Resolution request for {} {} from {}", resolve2.name(), resolve2.requestType(), this.$outer.sender());
                    this.$outer.akka$io$dns$internal$AsyncDnsManager$$resolver().forward(resolve2, this.$outer.context());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Dns.Resolve) {
                    Dns.Resolve resolve3 = (Dns.Resolve)A1;
                    String name = resolve3.name();
                    this.$outer.log().debug("Resolution request for {} from {}", name, this.$outer.sender());
                    this.$outer.akka$io$dns$internal$AsyncDnsManager$$warnAboutOldProtocolUse(name);
                    DnsProtocol.Resolve adapted = DnsProtocol$Resolve$.MODULE$.apply(name);
                    this.$outer.akka$io$dns$internal$AsyncDnsManager$$resolver().forward(adapted, this.$outer.context());
                    object = BoxedUnit.UNIT;
                } else if (AsyncDnsManager$CacheCleanup$.MODULE$.equals(A1)) {
                    this.$outer.akka$io$dns$internal$AsyncDnsManager$$cacheCleanup().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                        $anonfun$receive$1.$anonfun$applyOrElse$1(x$2);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve ? true : (object instanceof Dns.Resolve ? true : AsyncDnsManager$CacheCleanup$.MODULE$.equals(object));
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1(Dns x$2) {
                ((PeriodicCacheCleanup)((Object)x$2)).cleanup();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(akka.io.Dns )}, serializedLambda);
            }
        };
    }

    public void akka$io$dns$internal$AsyncDnsManager$$warnAboutOldProtocolUse(String name) {
        block0: {
            int warnAtMostTimes = 10;
            if (this.oldProtocolWarningLoggedTimes() >= warnAtMostTimes) break block0;
            this.oldProtocolWarningLoggedTimes_$eq(this.oldProtocolWarningLoggedTimes() + 1);
            this.log().warning("Received Dns.Resolve({}) message while Async DNS resolver active. Please use the new API [akka.io.dns.DnsProtocol] to issue resolve requests. (This warning will be logged at most {} times)", name, BoxesRunTime.boxToInteger((int)warnAtMostTimes));
        }
    }

    public static final /* synthetic */ void $anonfun$preStart$1(AsyncDnsManager $this, Dns x$1) {
        FiniteDuration interval = Duration$.MODULE$.apply($this.ext().Settings().ResolverConfig().getDuration("cache-cleanup-interval", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        $this.timers().startPeriodicTimer((Object)AsyncDnsManager$CacheCleanup$.MODULE$, (Object)AsyncDnsManager$CacheCleanup$.MODULE$, interval);
    }

    public AsyncDnsManager(DnsExt ext) {
        None$ none$;
        this.ext = ext;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        Timers.$init$(this);
        this.ec = this.context().dispatcher();
        this.oldProtocolWarningLoggedTimes = 0;
        this.settings = new DnsSettings(ext.system(), ext.Settings().ResolverConfig());
        Props props = FromConfig$.MODULE$.props(Props$.MODULE$.apply(ext.provider().actorClass(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings(), ext.cache(), (Function2 & Serializable & scala.Serializable)(factory, dns) -> (List)dns.map((Function1 & Serializable & scala.Serializable)ns -> factory.actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DnsClient((InetSocketAddress)ns), ClassTag$.MODULE$.apply(DnsClient.class))), List$.MODULE$.canBuildFrom())})).withDeploy(Deploy$.MODULE$.local()).withDispatcher(ext.Settings().Dispatcher()));
        this.akka$io$dns$internal$AsyncDnsManager$$resolver = this.context().actorOf(props, ext.Settings().Resolver());
        Dns dns2 = ext.cache();
        if (dns2 instanceof PeriodicCacheCleanup) {
            Dns dns3 = dns2;
            none$ = new Some((Object)dns3);
        } else {
            none$ = None$.MODULE$;
        }
        this.akka$io$dns$internal$AsyncDnsManager$$cacheCleanup = none$;
    }
}

