/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsCache;
import akka.io.SimpleDnsCache$;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsResolver;
import akka.io.dns.internal.AsyncDnsResolver$Ipv4Type$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv6Type$;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001-\u0011Q\"Q:z]\u000e$en]\"bG\",'BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003\r!gn\u001d\u0006\u0003\u000f!\t!![8\u000b\u0003%\tA!Y6lC\u000e\u00011c\u0001\u0001\r!A\u0011QBD\u0007\u0002\r%\u0011qB\u0002\u0002\u0004\t:\u001c\bCA\u0007\u0012\u0013\t\u0011bA\u0001\u000bQKJLw\u000eZ5d\u0007\u0006\u001c\u0007.Z\"mK\u0006tW\u000f\u001d\u0005\u0006)\u0001!\t!F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"a\u0006\u0001\u000e\u0003\tAq!\u0007\u0001C\u0002\u0013%!$A\u0003dC\u000eDW-F\u0001\u001c!\raReJ\u0007\u0002;)\u0011adH\u0001\u0007CR|W.[2\u000b\u0005\u0001\n\u0013AC2p]\u000e,(O]3oi*\u0011!eI\u0001\u0005kRLGNC\u0001%\u0003\u0011Q\u0017M^1\n\u0005\u0019j\"aD!u_6L7MU3gKJ,gnY3\u0011\t!\u0012TG\u0014\b\u0003SAr!AK\u0018\u000f\u0005-rS\"\u0001\u0017\u000b\u00055R\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u00022\r\u0005q1+[7qY\u0016$en]\"bG\",\u0017BA\u001a5\u0005\u0015\u0019\u0015m\u00195f\u0015\t\td\u0001\u0005\u00037sm\u001aU\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\rQ+\b\u000f\\33!\ta\u0004I\u0004\u0002>}A\u00111fN\u0005\u0003\u007f]\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qh\u000e\t\u0003\t.s!!R%\u000f\u0005\u0019CeBA\u0015H\u0013\t)a!\u0003\u0002\u0004\t%\u0011!JA\u0001\u0011\u0003NLhn\u0019#ogJ+7o\u001c7wKJL!\u0001T'\u0003\u0013E+XM]=UsB,'B\u0001&\u0003!\ryEKV\u0007\u0002!*\u0011\u0011KU\u0001\nS6lW\u000f^1cY\u0016T!aU\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002V!\n\u00191+Z9\u0011\u0005]CV\"\u0001\u0003\n\u0005e#!A\u0004*fg>,(oY3SK\u000e|'\u000f\u001a\u0005\u00077\u0002\u0001\u000b\u0011B\u000e\u0002\r\r\f7\r[3!\u0011\u001di\u0006A1A\u0005\ny\u000b\u0001B\\1o_\n\u000b7/Z\u000b\u0002?B\u0011a\u0007Y\u0005\u0003C^\u0012A\u0001T8oO\"11\r\u0001Q\u0001\n}\u000b\u0011B\\1o_\n\u000b7/\u001a\u0011\t\u000b\u0015\u0004A\u0011\t4\u0002\r\r\f7\r[3e)\t9\u0017\u000fE\u00027Q*L!![\u001c\u0003\r=\u0003H/[8o!\tYgN\u0004\u0002\u000eY&\u0011QNB\u0001\u0004\t:\u001c\u0018BA8q\u0005!\u0011Vm]8mm\u0016$'BA7\u0007\u0011\u0015\u0011H\r1\u0001<\u0003\u0011q\u0017-\\3\t\u000bQ\u0004A\u0011C;\u0002\u000b\rdwnY6\u0015\u0003}Caa\u001e\u0001\u0005\u0006\u0019A\u0018aA4fiR\u0011\u0011P\u001f\t\u0004m!t\u0005\"B>w\u0001\u0004)\u0014aA6fs\"1Q\u0010\u0001C\u0003\ry\f1\u0001];u)\u001dy\u0018QAA\u0004\u0003\u0017\u00012ANA\u0001\u0013\r\t\u0019a\u000e\u0002\u0005+:LG\u000fC\u0003|y\u0002\u0007Q\u0007\u0003\u0004\u0002\nq\u0004\rAT\u0001\be\u0016\u001cwN\u001d3t\u0011\u0019\ti\u0001 a\u0001?\u0006IA\u000f\u001e7NS2d\u0017n\u001d\u0015\u0004y\u0006E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]q'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0007\u0002\u0016\t9A/Y5me\u0016\u001c\u0007bBA\u0010\u0001\u0011\u0015\u0013\u0011E\u0001\bG2,\u0017M\\;q)\u0005y\b\u0006BA\u000f\u0003#A3\u0001AA\u0014!\u0011\tI#!\f\u000e\u0005\u0005-\"bAA\f\u0011%!\u0011qFA\u0016\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
public class AsyncDnsCache
extends Dns
implements PeriodicCacheCleanup {
    private final AtomicReference<SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, scala.collection.immutable.Seq<ResourceRecord>>> cache = new AtomicReference(new SimpleDnsCache.Cache((SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.clock()));
    private final long nanoBase = System.nanoTime();

    private AtomicReference<SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, scala.collection.immutable.Seq<ResourceRecord>>> cache() {
        return this.cache;
    }

    private long nanoBase() {
        return this.nanoBase;
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        return this.cache().get().get((Tuple2<String, AsyncDnsResolver.QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)ipv4 -> this.cache().get().get((Tuple2<String, AsyncDnsResolver.QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$)).map((Function1 & Serializable & scala.Serializable)ipv6 -> Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)((Iterable)((TraversableLike)ipv4.$plus$plus((GenTraversableOnce)ipv6, Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ResourceRecord, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ARecord) {
                    ARecord aRecord = (ARecord)A1;
                    object = aRecord.ip();
                } else if (A1 instanceof AAAARecord) {
                    AAAARecord aAAARecord = (AAAARecord)A1;
                    object = aAAARecord.ip();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ResourceRecord x1) {
                ResourceRecord resourceRecord = x1;
                boolean bl = resourceRecord instanceof ARecord ? true : resourceRecord instanceof AAAARecord;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())))));
    }

    public long clock() {
        long now = System.nanoTime();
        return now - this.nanoBase() < 0L ? 0L : (now - this.nanoBase()) / 1000000L;
    }

    public final Option<scala.collection.immutable.Seq<ResourceRecord>> get(Tuple2<String, AsyncDnsResolver.QueryType> key) {
        return this.cache().get().get(key);
    }

    public final void put(Tuple2<String, AsyncDnsResolver.QueryType> key, scala.collection.immutable.Seq<ResourceRecord> records, long ttlMillis) {
        SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, scala.collection.immutable.Seq<ResourceRecord>> c;
        do {
            c = this.cache().get();
        } while (!this.cache().compareAndSet(c, c.put(key, records, ttlMillis)));
    }

    @Override
    public final void cleanup() {
        SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, scala.collection.immutable.Seq<ResourceRecord>> c;
        do {
            c = this.cache().get();
        } while (!this.cache().compareAndSet(c, c.cleanup()));
    }
}

