/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.actors;

import akka.actor.ActorRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.application.interpreter.FromJsonFormat;

class RequestActorContext {
    private final Map<String, ActorRef> actors = new HashMap<String, ActorRef>();
    private final Map<String, List<ActorRef>> parents;
    private final Map<String, List<ActorRef>> children = new HashMap<String, List<ActorRef>>();
    private final FromJsonFormat<Set<String>> childrenExtractor;

    RequestActorContext(FromJsonFormat<Set<String>> childrenExtractor) {
        this.parents = new HashMap<String, List<ActorRef>>();
        this.childrenExtractor = childrenExtractor;
    }

    void addActor(String id, ActorRef actorRef) {
        this.actors.put(id, actorRef);
    }

    void addChild(String requestId, ActorRef ref) {
        this.children.computeIfAbsent(requestId, k -> new ArrayList()).add(ref);
    }

    void addParent(String requestId, ActorRef ref) {
        this.parents.computeIfAbsent(requestId, k -> new ArrayList()).add(ref);
    }

    ActorRef actorOf(String id) {
        return this.actors.get(id);
    }

    Collection<ActorRef> parentsOf(SagaRequest request) {
        return this.parents.getOrDefault(request.id(), Collections.emptyList());
    }

    Collection<ActorRef> childrenOf(SagaRequest request) {
        return this.children.getOrDefault(request.id(), Collections.emptyList());
    }

    void forAll(Consumer<ActorRef> consumer) {
        this.actors.values().stream().forEach(consumer);
    }

    Set<String> chosenChildren(SagaResponse response) {
        return (Set)this.childrenExtractor.fromJson(response.body());
    }
}

