/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.actors;

import akka.actor.AbstractActor;
import akka.actor.AbstractLoggingActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.servicecomb.saga.core.CompositeSagaResponse;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaStartFailedException;
import org.apache.servicecomb.saga.core.SagaTask;
import org.apache.servicecomb.saga.core.TransactionFailedException;
import org.apache.servicecomb.saga.core.actors.RequestActorContext;
import org.apache.servicecomb.saga.core.actors.messages.AbortMessage;
import org.apache.servicecomb.saga.core.actors.messages.AbortRecoveryMessage;
import org.apache.servicecomb.saga.core.actors.messages.CompensateMessage;
import org.apache.servicecomb.saga.core.actors.messages.CompensationRecoveryMessage;
import org.apache.servicecomb.saga.core.actors.messages.FailMessage;
import org.apache.servicecomb.saga.core.actors.messages.Message;
import org.apache.servicecomb.saga.core.actors.messages.TransactMessage;
import org.apache.servicecomb.saga.core.actors.messages.TransactionRecoveryMessage;

public class RequestActor
extends AbstractLoggingActor {
    private final RequestActorContext context;
    private final SagaTask task;
    private final SagaRequest request;
    private final List<SagaResponse> parentResponses;
    private final List<ActorRef> compensatedChildren;
    private final AbstractActor.Receive transacted;
    private final AbstractActor.Receive aborted;

    static Props props(RequestActorContext context, SagaTask task, SagaRequest request) {
        return Props.create(RequestActor.class, (Creator & Serializable)() -> new RequestActor(context, task, request));
    }

    private RequestActor(RequestActorContext context, SagaTask task, SagaRequest request) {
        this.context = context;
        this.task = task;
        this.request = request;
        this.parentResponses = new ArrayList<SagaResponse>(request.parents().length);
        this.compensatedChildren = new LinkedList<ActorRef>();
        this.aborted = this.onReceive(ignored -> {}).build();
        this.transacted = this.onReceive(arg_0 -> ((SagaTask)task).compensate(arg_0)).match(CompensationRecoveryMessage.class, message -> this.getContext().become(this.aborted)).build();
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(TransactMessage.class, message -> this.onTransaction((TransactMessage)message, () -> this.task.commit(this.request, this.responseOf(this.parentResponses)))).match(TransactionRecoveryMessage.class, this::onTransactRecovery).match(AbortRecoveryMessage.class, this::onAbortRecovery).match(AbortMessage.class, this::onAbort).build();
    }

    private void onAbort(AbortMessage message) {
        this.log().debug("{}: received abort message of {}", (Object)this.request.id(), (Object)message.response());
        this.sendToChildrenButSender(message);
        this.sendToParentsButSender(message);
        this.getContext().become(this.aborted);
    }

    private void sendToParentsButSender(AbortMessage message) {
        this.context.parentsOf(this.request).stream().filter(this::isNotSender).forEach(actor -> actor.tell((Object)message, this.self()));
    }

    private void sendToChildrenButSender(AbortMessage message) {
        this.context.childrenOf(this.request).stream().filter(this::isNotSender).forEach(actor -> actor.tell((Object)message, this.self()));
    }

    private boolean isNotSender(ActorRef actor) {
        return !actor.equals((Object)this.sender());
    }

    private void onTransactRecovery(TransactionRecoveryMessage message) {
        this.getContext().become(this.receiveBuilder().match(TransactMessage.class, m -> this.onTransaction((TransactMessage)m, message::response)).match(CompensationRecoveryMessage.class, m -> this.getContext().become(this.aborted)).build());
    }

    private void onAbortRecovery(AbortRecoveryMessage message) {
        this.getContext().become(this.receiveBuilder().match(TransactMessage.class, m -> this.onAbort(new AbortMessage(message.response()))).build());
    }

    private void onTransaction(TransactMessage message, Supplier<SagaResponse> responseSupplier) {
        this.log().debug("{}: received transaction message of {}", (Object)this.request.id(), (Object)message.request());
        if (this.context.parentsOf(this.request).contains(this.sender())) {
            this.parentResponses.add(message.response());
        }
        if (this.parentResponses.size() == this.context.parentsOf(this.request).size()) {
            this.transact(responseSupplier);
        }
    }

    private void transact(Supplier<SagaResponse> responseSupplier) {
        try {
            if (this.isChosenChild(this.parentResponses)) {
                SagaResponse sagaResponse = responseSupplier.get();
                this.sendToChildren(new TransactMessage(this.request, sagaResponse));
                this.getContext().become(this.transacted);
            } else {
                this.sendToChildren(new TransactMessage(this.request, SagaResponse.NONE_RESPONSE));
                this.getContext().become(this.aborted);
            }
        }
        catch (SagaStartFailedException e) {
            this.sendToParents(new FailMessage(e));
        }
        catch (Exception e) {
            this.log().error("Failed to run operation {} with error {}", (Object)this.request.transaction(), (Object)e);
            AbortMessage abortMessage = new AbortMessage((Throwable)new TransactionFailedException((Throwable)e));
            this.sendToParents(abortMessage);
            this.sendToChildren(abortMessage);
            this.getContext().become(this.aborted);
        }
    }

    private void sendToParents(Message message) {
        this.context.parentsOf(this.request).forEach(actor -> actor.tell((Object)message, this.self()));
    }

    private void sendToChildren(Message message) {
        this.context.childrenOf(this.request).forEach(actor -> actor.tell((Object)message, this.self()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isChosenChild(List<SagaResponse> parentResponses) {
        if (this.request.parents().length == 0) return true;
        if (parentResponses.isEmpty()) return true;
        if (!parentResponses.stream().map(this.context::chosenChildren).anyMatch(chosenChildren -> chosenChildren.isEmpty() || chosenChildren.contains(this.request.id()))) return false;
        return true;
    }

    private SagaResponse responseOf(List<SagaResponse> responseContexts) {
        if (responseContexts.isEmpty()) {
            return SagaResponse.EMPTY_RESPONSE;
        }
        if (responseContexts.size() == 1) {
            return responseContexts.get(0);
        }
        return new CompositeSagaResponse(responseContexts);
    }

    private ReceiveBuilder onReceive(Consumer<SagaRequest> requestConsumer) {
        return this.receiveBuilder().match(CompensateMessage.class, message -> this.onCompensate((CompensateMessage)message, requestConsumer));
    }

    private void onCompensate(CompensateMessage message, Consumer<SagaRequest> requestConsumer) {
        this.log().debug("{}: received compensation message from {}", (Object)this.request.id(), (Object)this.sender());
        this.compensatedChildren.add(this.sender());
        if (this.compensatedChildren.size() == this.context.childrenOf(this.request).size()) {
            requestConsumer.accept(this.request);
            this.sendToParents(message);
        }
    }
}

