/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.actors;

import akka.actor.ActorRef;
import org.apache.servicecomb.saga.core.EventContext;
import org.apache.servicecomb.saga.core.SagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.actors.RequestActorContext;
import org.apache.servicecomb.saga.core.actors.messages.AbortRecoveryMessage;
import org.apache.servicecomb.saga.core.actors.messages.CompensationRecoveryMessage;
import org.apache.servicecomb.saga.core.actors.messages.Message;
import org.apache.servicecomb.saga.core.actors.messages.TransactionRecoveryMessage;

public class EventContextImpl
implements EventContext {
    private final RequestActorContext context;

    EventContextImpl(RequestActorContext context) {
        this.context = context;
    }

    public void beginTransaction(SagaRequest request) {
    }

    public void endTransaction(SagaRequest request, SagaResponse response) {
        this.sendMessage(request, new TransactionRecoveryMessage(response));
    }

    public void abortTransaction(SagaRequest request, SagaResponse response) {
        this.sendMessage(request, new AbortRecoveryMessage(response));
    }

    public void compensateTransaction(SagaRequest request, SagaResponse response) {
        this.sendMessage(request, new CompensationRecoveryMessage());
    }

    private void sendMessage(SagaRequest request, Message message) {
        this.context.actorOf(request.id()).tell((Object)message, ActorRef.noSender());
    }
}

