/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.actors;

import akka.actor.AbstractActor;
import akka.actor.AbstractLoggingActor;
import akka.actor.Props;
import akka.japi.Creator;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.saga.core.NoOpSagaRequest;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.actors.RequestActorContext;
import org.apache.servicecomb.saga.core.actors.messages.AbortMessage;
import org.apache.servicecomb.saga.core.actors.messages.CompensateMessage;
import org.apache.servicecomb.saga.core.actors.messages.FailMessage;
import org.apache.servicecomb.saga.core.actors.messages.TransactMessage;

class CompletionCallbackActor
extends AbstractLoggingActor {
    private final CompletableFuture<SagaResponse> future;

    private CompletionCallbackActor(CompletableFuture<SagaResponse> future) {
        this.future = future;
    }

    static Props props(CompletableFuture<SagaResponse> future) {
        return Props.create(CompletionCallbackActor.class, (Creator & Serializable)() -> new CompletionCallbackActor(future));
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RequestActorContext.class, this::ready).build();
    }

    private void ready(RequestActorContext context) {
        this.getContext().become(this.receiveBuilder().match(CompensateMessage.class, message -> this.end(context, message.response())).match(TransactMessage.class, message -> this.end(context, message.response())).match(AbortMessage.class, message -> this.onAbort(context, (AbortMessage)message)).match(FailMessage.class, message -> this.end(context, message.response())).build());
    }

    private void onAbort(RequestActorContext context, AbortMessage message) {
        this.log().info("saga actor: received abort message of {}", (Object)message.response());
        context.actorOf(NoOpSagaRequest.SAGA_END_REQUEST.id()).tell((Object)new CompensateMessage(message.response()), this.self());
    }

    private void end(RequestActorContext context, SagaResponse response) {
        this.log().info("saga actor: received response {}", (Object)response);
        this.future.complete(response);
        context.forAll(actor -> this.getContext().stop(actor));
        this.getContext().stop(this.self());
    }
}

