/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.actors;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.saga.core.EventStore;
import org.apache.servicecomb.saga.core.NoOpSagaRequest;
import org.apache.servicecomb.saga.core.PersistentStore;
import org.apache.servicecomb.saga.core.SagaDefinition;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.SagaTaskFactory;
import org.apache.servicecomb.saga.core.actors.ActorBasedSaga;
import org.apache.servicecomb.saga.core.actors.CompletionCallbackActor;
import org.apache.servicecomb.saga.core.actors.EventContextImpl;
import org.apache.servicecomb.saga.core.actors.RequestActorBuilder;
import org.apache.servicecomb.saga.core.actors.RequestActorContext;
import org.apache.servicecomb.saga.core.application.SagaFactory;
import org.apache.servicecomb.saga.core.application.interpreter.FromJsonFormat;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

public class ActorBasedSagaFactory
implements SagaFactory {
    private final ActorSystem actorSystem = ActorSystem.create((String)"saga");
    private final RequestActorBuilder actorBuilder;
    private final SagaTaskFactory sagaTaskFactory;

    public ActorBasedSagaFactory(int retryDelay, PersistentStore persistentStore, FromJsonFormat<Set<String>> childrenExtractor) {
        this.sagaTaskFactory = new SagaTaskFactory(retryDelay, persistentStore);
        this.actorBuilder = new RequestActorBuilder(this.actorSystem, childrenExtractor);
    }

    public ActorBasedSaga createSaga(String requestJson, String sagaId, EventStore sagaLog, SagaDefinition definition) {
        CompletableFuture<SagaResponse> future = new CompletableFuture<SagaResponse>();
        ActorRef completionCallback = this.actorSystem.actorOf(CompletionCallbackActor.props(future));
        RequestActorContext context = this.actorBuilder.build(definition.requests(), this.sagaTaskFactory.sagaTasks(sagaId, requestJson, definition.policy(), sagaLog), completionCallback);
        completionCallback.tell((Object)context, ActorRef.noSender());
        return new ActorBasedSaga(context.actorOf(NoOpSagaRequest.SAGA_START_REQUEST.id()), completionCallback, future, sagaLog, new EventContextImpl(context));
    }

    public boolean isTerminated() {
        return this.actorSystem.whenTerminated().isCompleted();
    }

    public void terminate() throws Exception {
        Await.result((Awaitable)this.actorSystem.terminate(), (Duration)Duration.Inf());
    }
}

