/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.core.actors;

import akka.actor.ActorRef;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.saga.core.EventContext;
import org.apache.servicecomb.saga.core.EventStore;
import org.apache.servicecomb.saga.core.NoOpSagaRequest;
import org.apache.servicecomb.saga.core.Saga;
import org.apache.servicecomb.saga.core.SagaEvent;
import org.apache.servicecomb.saga.core.SagaResponse;
import org.apache.servicecomb.saga.core.actors.messages.TransactMessage;

public class ActorBasedSaga
implements Saga {
    private final ActorRef root;
    private final ActorRef completionCallback;
    private final CompletableFuture<SagaResponse> future;
    private final EventStore sagaLog;
    private final EventContext sagaContext;

    ActorBasedSaga(ActorRef root, ActorRef completionCallback, CompletableFuture<SagaResponse> future, EventStore sagaLog, EventContext sagaContext) {
        this.root = root;
        this.completionCallback = completionCallback;
        this.future = future;
        this.sagaLog = sagaLog;
        this.sagaContext = sagaContext;
    }

    public SagaResponse run() {
        this.root.tell((Object)new TransactMessage(NoOpSagaRequest.SAGA_START_REQUEST, SagaResponse.EMPTY_RESPONSE), this.completionCallback);
        return this.future.join();
    }

    public void play() {
        this.gatherEvents((Iterable<SagaEvent>)this.sagaLog);
    }

    private void gatherEvents(Iterable<SagaEvent> events) {
        for (SagaEvent event : events) {
            event.gatherTo(this.sagaContext);
        }
    }
}

