/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicecomb.pack.alpha.spec.saga.akka.properties;

public class ElasticsearchProperties {

  private String uris;
  // TODO
  //  Size of bulk request, When this value is greater than 0, the batch data will be lost when the jvm crashes.
  //  In the future, we can use Kafka to solve this problem instead of storing it directly in the ES.
  private int batchSize = 100;
  private int refreshTime = 5000;

  public String getUris() {
    return uris;
  }

  public void setUris(String uris) {
    this.uris = uris;
  }

  public int getBatchSize() {
    return batchSize;
  }

  public void setBatchSize(int batchSize) {
    this.batchSize = batchSize;
  }

  public int getRefreshTime() {
    return refreshTime;
  }

  public void setRefreshTime(int refreshTime) {
    this.refreshTime = refreshTime;
  }
}