/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.spring;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.servicecomb.pack.common.AlphaMetaKeys;
import org.apache.servicecomb.pack.contract.grpc.ServerMeta;
import org.apache.servicecomb.pack.omega.connector.grpc.AlphaClusterConfig;
import org.apache.servicecomb.pack.omega.connector.grpc.AlphaClusterDiscovery;
import org.apache.servicecomb.pack.omega.context.AlphaMetas;
import org.apache.servicecomb.pack.omega.context.IdGenerator;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.ServiceConfig;
import org.apache.servicecomb.pack.omega.context.UniqueIdGenerator;
import org.apache.servicecomb.pack.omega.format.KryoMessageFormat;
import org.apache.servicecomb.pack.omega.transaction.MessageDeserializer;
import org.apache.servicecomb.pack.omega.transaction.MessageHandler;
import org.apache.servicecomb.pack.omega.transaction.MessageSerializer;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
class OmegaSpringConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    OmegaSpringConfig() {
    }

    @ConditionalOnMissingBean
    @Bean(name={"omegaUniqueIdGenerator"})
    IdGenerator<String> idGenerator() {
        return new UniqueIdGenerator();
    }

    @Bean
    OmegaContext omegaContext(@Qualifier(value="omegaUniqueIdGenerator") IdGenerator<String> idGenerator, @Autowired(required=false) SagaMessageSender messageSender) {
        if (messageSender != null) {
            ServerMeta serverMeta = messageSender.onGetServerMeta();
            boolean akkaEnabeld = false;
            if (serverMeta != null) {
                akkaEnabeld = Boolean.parseBoolean((String)serverMeta.getMetaMap().get(AlphaMetaKeys.AkkaEnabled.name()));
            }
            return new OmegaContext(idGenerator, AlphaMetas.builder().akkaEnabled(akkaEnabeld).build());
        }
        return new OmegaContext(idGenerator, AlphaMetas.builder().build());
    }

    @Bean
    ServiceConfig serviceConfig(@Value(value="${spring.application.name}") String serviceName, @Value(value="${omega.instance.instanceId:#{null}}") String instanceId) {
        return new ServiceConfig(serviceName, instanceId);
    }

    @Bean
    @ConditionalOnProperty(name={"alpha.cluster.register.type"}, havingValue="default", matchIfMissing=true)
    AlphaClusterDiscovery alphaClusterAddress(@Value(value="${alpha.cluster.address:0.0.0.0:8080}") String[] addresses) {
        return AlphaClusterDiscovery.builder().addresses(addresses).build();
    }

    @Bean
    AlphaClusterConfig alphaClusterConfig(@Value(value="${alpha.cluster.ssl.enable:false}") boolean enableSSL, @Value(value="${alpha.cluster.ssl.mutualAuth:false}") boolean mutualAuth, @Value(value="${alpha.cluster.ssl.cert:client.crt}") String cert, @Value(value="${alpha.cluster.ssl.key:client.pem}") String key, @Value(value="${alpha.cluster.ssl.certChain:ca.crt}") String certChain, @Lazy AlphaClusterDiscovery alphaClusterDiscovery, @Lazy MessageHandler handler, @Lazy TccMessageHandler tccMessageHandler) {
        LOG.info("Discovery alpha cluster address {} from {}", (Object)(alphaClusterDiscovery.getAddresses() == null ? "" : String.join((CharSequence)",", alphaClusterDiscovery.getAddresses())), (Object)alphaClusterDiscovery.getDiscoveryType().name());
        KryoMessageFormat messageFormat = new KryoMessageFormat();
        AlphaClusterConfig clusterConfig = AlphaClusterConfig.builder().addresses((List)ImmutableList.copyOf((Object[])alphaClusterDiscovery.getAddresses())).enableSSL(enableSSL).enableMutualAuth(mutualAuth).cert(cert).key(key).certChain(certChain).messageDeserializer((MessageDeserializer)messageFormat).messageSerializer((MessageSerializer)messageFormat).messageHandler(handler).tccMessageHandler(tccMessageHandler).build();
        return clusterConfig;
    }
}

