/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.spring;

import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.omega.connector.grpc.AlphaClusterConfig;
import org.apache.servicecomb.pack.omega.connector.grpc.core.FastestSender;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContextBuilder;
import org.apache.servicecomb.pack.omega.connector.grpc.core.MessageSenderPicker;
import org.apache.servicecomb.pack.omega.connector.grpc.core.TransactionType;
import org.apache.servicecomb.pack.omega.connector.grpc.saga.SagaLoadBalanceSender;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.ServiceConfig;
import org.apache.servicecomb.pack.omega.transaction.CallbackContext;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="'${omega.spec.names}'.contains('saga')")
class OmegaSagaSpringConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public OmegaSagaSpringConfig() {
        LOG.info("Omega Specification Saga");
    }

    @Bean(name={"compensationContext"})
    CallbackContext compensationContext(OmegaContext omegaContext, SagaMessageSender sender) {
        return new CallbackContext(omegaContext, sender);
    }

    @Bean(name={"sagaLoadContext"})
    LoadBalanceContext sagaLoadBalanceSenderContext(AlphaClusterConfig alphaClusterConfig, ServiceConfig serviceConfig, @Value(value="${omega.connection.reconnectDelay:3000}") int reconnectDelay, @Value(value="${omega.connection.sending.timeout:8}") int timeoutSeconds) {
        LoadBalanceContext loadBalanceSenderContext = new LoadBalanceContextBuilder(TransactionType.SAGA, alphaClusterConfig, serviceConfig, reconnectDelay, timeoutSeconds).build();
        return loadBalanceSenderContext;
    }

    @Bean
    SagaMessageSender sagaLoadBalanceSender(@Qualifier(value="sagaLoadContext") LoadBalanceContext loadBalanceSenderContext) {
        SagaLoadBalanceSender sagaMessageSender = new SagaLoadBalanceSender(loadBalanceSenderContext, (MessageSenderPicker)new FastestSender());
        sagaMessageSender.onConnected();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable((SagaMessageSender)sagaMessageSender){
            final /* synthetic */ SagaMessageSender val$sagaMessageSender;
            {
                this.val$sagaMessageSender = sagaMessageSender;
            }

            @Override
            public void run() {
                this.val$sagaMessageSender.onDisconnected();
                this.val$sagaMessageSender.close();
            }
        }));
        return sagaMessageSender;
    }
}

