/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.wrapper;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.pack.omega.transaction.wrapper.TimeoutProb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutProbManager {
    private static TimeoutProbManager instance = new TimeoutProbManager(100);
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final transient Set<TimeoutProb> timeoutProbs = new ConcurrentSkipListSet<TimeoutProb>();
    private final transient ScheduledExecutorService interrupter = Executors.newSingleThreadScheduledExecutor(new TimeoutProbeThreadFactory());

    public static TimeoutProbManager getInstance() {
        return instance;
    }

    public TimeoutProbManager(int delay) {
        this.interrupter.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    TimeoutProbManager.this.interrupt();
                }
                catch (Exception e) {
                    LOG.error("The overtime thread interrupt fail", (Throwable)e);
                }
            }
        }, 0L, delay, TimeUnit.MICROSECONDS);
    }

    public TimeoutProb addTimeoutProb(int timeout) {
        TimeoutProb timeoutProb = new TimeoutProb(timeout);
        this.timeoutProbs.add(timeoutProb);
        return timeoutProb;
    }

    public void removeTimeoutProb(TimeoutProb timeoutProb) {
        this.timeoutProbs.remove(timeoutProb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrupt() {
        ScheduledExecutorService scheduledExecutorService = this.interrupter;
        synchronized (scheduledExecutorService) {
            for (TimeoutProb timeoutProb : this.timeoutProbs) {
                if (timeoutProb.getInterruptFailureException() != null || !timeoutProb.expired() || !timeoutProb.interrupted()) continue;
                this.timeoutProbs.remove(timeoutProb);
            }
        }
    }

    public class TimeoutProbeThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(new ThreadGroup("recovery-policy-timeout-wrapper"), runnable, "probe");
            thread.setPriority(10);
            thread.setDaemon(true);
            return thread;
        }
    }
}

