/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.wrapper;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutProb
implements Comparable<TimeoutProb> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final transient Thread thread = Thread.currentThread();
    private final transient long startTime = System.currentTimeMillis();
    private final transient long expireTime;
    private Exception interruptFailureException = null;
    private boolean interruptSent = false;

    public TimeoutProb(int timeout) {
        this.expireTime = this.startTime + TimeUnit.SECONDS.toMillis(timeout);
    }

    @Override
    public int compareTo(TimeoutProb obj) {
        int compare = this.expireTime > obj.expireTime ? 1 : (this.expireTime < obj.expireTime ? -1 : 0);
        return compare;
    }

    public Exception getInterruptFailureException() {
        return this.interruptFailureException;
    }

    public boolean expired() {
        return this.expireTime < System.currentTimeMillis();
    }

    public boolean interrupted() {
        boolean interrupted;
        if (this.thread.isAlive()) {
            try {
                this.thread.interrupt();
                if (!this.interruptSent) {
                    LOG.warn("Thread interrupted on {}ms timeout (over {}ms)", new Object[]{System.currentTimeMillis() - this.startTime, this.expireTime - this.startTime});
                }
                this.interruptSent = true;
            }
            catch (Exception e) {
                this.interruptFailureException = e;
                LOG.info("Failed to interrupt the thread " + this.thread.getName(), (Throwable)e);
                throw e;
            }
            interrupted = false;
        } else {
            interrupted = true;
        }
        return interrupted;
    }
}

