/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.wrapper;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.annotations.SagaStart;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.SagaStartAnnotationProcessor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaStartAnnotationProcessorWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SagaStartAnnotationProcessor sagaStartAnnotationProcessor;

    public SagaStartAnnotationProcessorWrapper(SagaStartAnnotationProcessor sagaStartAnnotationProcessor) {
        this.sagaStartAnnotationProcessor = sagaStartAnnotationProcessor;
    }

    public Object apply(ProceedingJoinPoint joinPoint, SagaStart sagaStart, OmegaContext context) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        this.sagaStartAnnotationProcessor.preIntercept(sagaStart.timeout());
        LOG.debug("Initialized context {} before execution of method {}", (Object)context, (Object)method.toString());
        try {
            Object result = joinPoint.proceed();
            if (sagaStart.autoClose()) {
                this.sagaStartAnnotationProcessor.postIntercept(context.globalTxId());
                LOG.debug("Transaction with context {} has finished.", (Object)context);
            } else {
                LOG.debug("Transaction with context {} is not finished in the SagaStarted annotated method.", (Object)context);
            }
            Object object = result;
            return object;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof OmegaException)) {
                this.sagaStartAnnotationProcessor.onError(method.toString(), throwable);
                LOG.error("Transaction {} failed.", (Object)context.globalTxId());
            }
            throw throwable;
        }
        finally {
            context.clear();
        }
    }
}

